//Made by FSang18
StartupEvents.registry('palladium:abilities', (event) => {
    event.create('finalcut:capture_username')
        .icon(palladium.createItemIcon('minecraft:name_tag'))
        .addProperty('range', 'float', 10.0, 'Range to look for a player within.')
        .addProperty('property_name', 'string', 'FinalCut.PlayerName', 'Palladium property to save the username to.')
        .tick((entity, entry, holder, enabled) => {
            if (!enabled || !entity || !entity.isPlayer()) return;

            const range = entry.getPropertyByName('range');
            const propKey = entry.getPropertyByName('property_name');

            const hit = entity.rayTrace(range);
            if (!hit || !hit.entity) return;

            const target = hit.entity;
            if (target && target.isPlayer() && target !== entity) {
                const uname = target.getGameProfile().getName();
                palladium.setProperty(entity, propKey, String(uname));
            }
        });
});