/*
 * Telekinesis
 * Requires: Pehkui
 * Developed by phantompig, inspired by Matt
 */

let $Util = Java.loadClass('net.minecraft.Util');
let $ScaleTypes = Java.loadClass('virtuoel.pehkui.api.ScaleTypes');

StartupEvents.registry('palladium:abilities', event => {
    event.create('finalcut:telekinesis_entity')
        .icon(palladium.createItemIcon('minecraft:player_head'))

        .documentationDescription('Telekinesis: grab entities and float them in front of you.')

        .addProperty('range', 'float', 15, 'The range of the ability.')
        .addProperty('strength_multiplier', 'float', 0.8, 'The strength/speed of the telekinesis.')

        .addUniqueProperty('held_entity', 'uuid', $Util.NIL_UUID)

        .firstTick((entity, entry, holder, enabled) => {
            if (enabled) {
                let rayTrace = entity.rayTrace(entry.getPropertyByName('range'), false);

                if (rayTrace.entity != null) {
                    entry.setUniquePropertyByName('held_entity', rayTrace.entity.uuid);
                } 
            }
        })

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                let heldEntity = getHeldEntity(entity.level, entry);
                if (heldEntity == null) return;
                let range = entry.getPropertyByName('range');
                let rayTrace = entity.rayTrace(range);
                let lookVec = entity.getLookAngle();
                let boundingBox = heldEntity.getBoundingBox();

                let targetPos = (rayTrace.entity == heldEntity ? rayTrace.hit.add(lookVec) : rayTrace.hit) ?? entity.getEyePosition().add(lookVec.scale(range));

                heldEntity.setDeltaMovement(targetPos.subtract(heldEntity.getEyePosition()).scale(entry.getPropertyByName('strength_multiplier')));
                heldEntity.resetFallDistance();


                entity.level.sendParticles(
                    'minecraft:enchant',
                    heldEntity.x, heldEntity.y, heldEntity.z,
            /*count*/ 2,
                    boundingBox.getXsize(), boundingBox.getYsize(), boundingBox.getZsize(),
            /*speed*/ 0
                );
                entity.level.sendParticles(
                    'minecraft:enchanted_hit',
                    heldEntity.x, heldEntity.y, heldEntity.z,
            /*count*/ 1,
                    boundingBox.getXsize(), boundingBox.getYsize(), boundingBox.getZsize(),
            /*speed*/ 0
                );
            }
        })

        .lastTick((entity, entry, holder, enabled) => {
            entry.setUniquePropertyByName('held_entity', $Util.NIL_UUID);
        });
});

function getHeldEntity(level, entry) {
    let uuid = entry.getPropertyByName('held_entity');
    if (uuid == $Util.NIL_UUID) return;
    return getEntity(level, uuid);
}
function getEntity(level, uuid) {
    if (uuid == null || uuid == $Util.NIL_UUID) return null;
    let entities = level.getEntities();
    for (let i = 0; i < entities.size(); i++) {
        if (entities.get(i).uuid.equals(uuid)) {
            return entities.get(i);
        }
    }
}
