/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import terrablender.core.TerraBlender;
import terrablender.util.WeightedEntry;

public class EndBiomeRegistry {
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> highlandsBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> midlandsBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> edgeBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> islandBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();

    public static void registerHighlandsBiome(ResourceKey<Biome> biome, int weight) {
        highlandsBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerMidlandsBiome(ResourceKey<Biome> biome, int weight) {
        midlandsBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerEdgeBiome(ResourceKey<Biome> biome, int weight) {
        edgeBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerIslandBiome(ResourceKey<Biome> biome, int weight) {
        islandBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getHighlandsBiomes() {
        return ImmutableList.copyOf(highlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getMidlandsBiomes() {
        return ImmutableList.copyOf(midlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getEdgeBiomes() {
        return ImmutableList.copyOf(edgeBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getIslandBiomes() {
        return ImmutableList.copyOf(islandBiomes);
    }

    static {
        EndBiomeRegistry.registerHighlandsBiome((ResourceKey<Biome>)Biomes.END_HIGHLANDS, TerraBlender.CONFIG.vanillaEndHighlandsWeight);
        EndBiomeRegistry.registerMidlandsBiome((ResourceKey<Biome>)Biomes.END_MIDLANDS, TerraBlender.CONFIG.vanillaEndMidlandsWeight);
        EndBiomeRegistry.registerEdgeBiome((ResourceKey<Biome>)Biomes.END_BARRENS, TerraBlender.CONFIG.vanillaEndBarrensWeight);
        EndBiomeRegistry.registerIslandBiome((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS, TerraBlender.CONFIG.vanillaSmallEndIslandsWeight);
    }
}

