/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ModifiedVanillaOverworldBuilder;
import terrablender.api.ParameterUtils;
import terrablender.api.RegionType;
import terrablender.worldgen.RegionUtils;

public abstract class Region {
    public static final ResourceKey<Biome> DEFERRED_PLACEHOLDER = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)"terrablender", (String)"deferred_placeholder"));
    private final Identifier name;
    private RegionType type;
    private int weight;

    public Region(Identifier name, RegionType type, int weight) {
        this.name = name;
        this.type = type;
        this.weight = weight;
    }

    public Identifier getName() {
        return this.name;
    }

    public RegionType getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
    }

    protected final void addBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        this.addBiome(mapper, Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (float)offset), biome);
    }

    protected final void addBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness, ParameterUtils.Erosion erosion, ParameterUtils.Weirdness weirdness, ParameterUtils.Depth depth, float offset, ResourceKey<Biome> biome) {
        this.addBiome(mapper, Climate.parameters((Climate.Parameter)temperature.parameter(), (Climate.Parameter)humidity.parameter(), (Climate.Parameter)continentalness.parameter(), (Climate.Parameter)erosion.parameter(), (Climate.Parameter)depth.parameter(), (Climate.Parameter)weirdness.parameter(), (float)offset), biome);
    }

    protected final void addBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.ParameterPoint parameters, ResourceKey<Biome> biome) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)parameters, biome));
    }

    protected final void addBiomeSimilar(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ResourceKey<Biome> similarVanillaBiome, ResourceKey<Biome> biome) {
        List points = (List)RegionUtils.getVanillaParameterPoints(similarVanillaBiome).stream().collect(ImmutableList.toImmutableList());
        points.forEach(point -> this.addBiome(mapper, (Climate.ParameterPoint)point, biome));
    }

    protected final void addModifiedVanillaOverworldBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Consumer<ModifiedVanillaOverworldBuilder> onModify) {
        ModifiedVanillaOverworldBuilder builder = new ModifiedVanillaOverworldBuilder();
        onModify.accept(builder);
        builder.build().forEach(mapper::accept);
    }
}

