/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import terrablender.DimensionTypeTags;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;
import terrablender.core.TerraBlender;
import terrablender.worldgen.IExtendedBiomeSource;
import terrablender.worldgen.IExtendedNoiseGeneratorSettings;
import terrablender.worldgen.IExtendedParameterList;
import terrablender.worldgen.IExtendedTheEndBiomeSource;

public class LevelUtils {
    public static void initializeOnServerStart(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Registry levelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        long seed = server.getWorldData().worldGenOptions().seed();
        for (Map.Entry entry : levelStemRegistry.entrySet()) {
            LevelStem stem = (LevelStem)entry.getValue();
            LevelUtils.initializeBiomes((RegistryAccess)registryAccess, (Holder<DimensionType>)stem.type(), (ResourceKey<LevelStem>)((ResourceKey)entry.getKey()), stem.generator(), seed);
        }
    }

    public static boolean shouldApplyToChunkGenerator(ChunkGenerator chunkGenerator) {
        return chunkGenerator instanceof NoiseBasedChunkGenerator && LevelUtils.shouldApplyToBiomeSource(chunkGenerator.getBiomeSource());
    }

    public static boolean shouldApplyToBiomeSource(BiomeSource biomeSource) {
        return biomeSource instanceof MultiNoiseBiomeSource;
    }

    public static RegionType getRegionTypeForDimension(Holder<DimensionType> dimensionType) {
        if (dimensionType.is(DimensionTypeTags.NETHER_REGIONS)) {
            return RegionType.NETHER;
        }
        if (dimensionType.is(DimensionTypeTags.OVERWORLD_REGIONS)) {
            return RegionType.OVERWORLD;
        }
        return null;
    }

    public static void initializeBiomes(RegistryAccess registryAccess, Holder<DimensionType> dimensionType, ResourceKey<LevelStem> levelResourceKey, ChunkGenerator chunkGenerator, long seed) {
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return;
        }
        NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
        NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
        if (chunkGenerator.getBiomeSource() instanceof TheEndBiomeSource) {
            ((IExtendedTheEndBiomeSource)chunkGenerator.getBiomeSource()).initializeForTerraBlender(registryAccess, seed);
            ((IExtendedNoiseGeneratorSettings)generatorSettings).setRuleCategory(SurfaceRuleManager.RuleCategory.END);
            return;
        }
        if (!LevelUtils.shouldApplyToBiomeSource(chunkGenerator.getBiomeSource())) {
            return;
        }
        RegionType regionType = LevelUtils.getRegionTypeForDimension(dimensionType);
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)chunkGenerator.getBiomeSource();
        IExtendedBiomeSource biomeSourceEx = (IExtendedBiomeSource)biomeSource;
        if (regionType == null) {
            return;
        }
        SurfaceRuleManager.RuleCategory ruleCategory = switch (regionType) {
            case RegionType.OVERWORLD -> SurfaceRuleManager.RuleCategory.OVERWORLD;
            case RegionType.NETHER -> SurfaceRuleManager.RuleCategory.NETHER;
            default -> throw new IllegalArgumentException("Attempted to get surface rule category for unsupported region type " + String.valueOf((Object)regionType));
        };
        ((IExtendedNoiseGeneratorSettings)generatorSettings).setRuleCategory(ruleCategory);
        Climate.ParameterList parameters = biomeSource.parameters();
        IExtendedParameterList parametersEx = (IExtendedParameterList)parameters;
        parametersEx.initializeForTerraBlender(registryAccess, regionType, seed);
        Registry biomeRegistry = registryAccess.lookupOrThrow(Registries.BIOME);
        ImmutableList.Builder builder = ImmutableList.builder();
        Regions.get(regionType).forEach(region -> region.addBiomes((Registry<Biome>)biomeRegistry, pair -> {
            if (biomeRegistry.containsKey((ResourceKey)pair.getSecond())) {
                builder.add((Object)biomeRegistry.getOrThrow((ResourceKey)pair.getSecond()));
            }
        }));
        biomeSourceEx.appendDeferredBiomesList((List<Holder<Biome>>)builder.build());
        TerraBlender.LOGGER.info(String.format("Initialized TerraBlender biomes for level stem %s", levelResourceKey.identifier()));
    }
}

