/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import terrablender.util.WeightedEntry;
import terrablender.worldgen.noise.WeightedRandomLayer;

public class BiomeInitialLayer
extends WeightedRandomLayer<WeightedEntry.Wrapper<ResourceKey<Biome>>> {
    private final Registry<Biome> biomeRegistry;

    public BiomeInitialLayer(RegistryAccess registryAccess, List<WeightedEntry.Wrapper<ResourceKey<Biome>>> entries) {
        super(entries);
        this.biomeRegistry = registryAccess.lookupOrThrow(Registries.BIOME);
    }

    @Override
    protected int getEntryIndex(WeightedEntry.Wrapper<ResourceKey<Biome>> entry) {
        return this.resolveId(entry.data());
    }

    @Override
    protected int getDefaultIndex() {
        return this.resolveId((ResourceKey<Biome>)Biomes.OCEAN);
    }

    private int resolveId(ResourceKey<Biome> key) {
        if (!this.biomeRegistry.containsKey(key)) {
            throw new RuntimeException("Attempted to resolve id for unregistered biome " + String.valueOf(key));
        }
        return this.biomeRegistry.getId((Object)((Biome)((Holder.Reference)this.biomeRegistry.get(key).get()).value()));
    }
}

