/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.surface;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record NamespacedSurfaceRuleSource(SurfaceRules.RuleSource base, Map<String, SurfaceRules.RuleSource> sources) implements SurfaceRules.RuleSource
{
    public static final KeyDispatchDataCodec<NamespacedSurfaceRuleSource> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(builder -> builder.group((App)SurfaceRules.RuleSource.CODEC.fieldOf("base").forGetter(NamespacedSurfaceRuleSource::base), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SurfaceRules.RuleSource.CODEC).fieldOf("sources").forGetter(NamespacedSurfaceRuleSource::sources)).apply((Applicative)builder, NamespacedSurfaceRuleSource::new)));

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        ImmutableMap.Builder rules = new ImmutableMap.Builder();
        this.sources.entrySet().forEach(entry -> rules.put((Object)((String)entry.getKey()), (Object)((SurfaceRules.SurfaceRule)((SurfaceRules.RuleSource)entry.getValue()).apply((Object)context))));
        return new NamespacedRule(context, (SurfaceRules.SurfaceRule)this.base.apply((Object)context), (Map<String, SurfaceRules.SurfaceRule>)rules.build());
    }

    record NamespacedRule(SurfaceRules.Context context, SurfaceRules.SurfaceRule baseRule, Map<String, SurfaceRules.SurfaceRule> rules) implements SurfaceRules.SurfaceRule
    {
        public BlockState tryApply(int x, int y, int z) {
            Holder biome = (Holder)this.context.biome.get();
            BlockState state = null;
            if (biome.is(key -> this.rules.containsKey(key.location().getNamespace()))) {
                state = this.rules.get(((ResourceKey)biome.unwrapKey().get()).location().getNamespace()).tryApply(x, y, z);
            }
            if (state == null) {
                state = this.baseRule.tryApply(x, y, z);
            }
            return state;
        }
    }
}

