/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.marsrenaissance.init;

import net.mcreator.marsrenaissance.entity.LaserGunProjectileEntity;
import net.mcreator.marsrenaissance.entity.LaserShotgunProjectileEntity;
import net.mcreator.marsrenaissance.entity.MarslienEntity;
import net.mcreator.marsrenaissance.entity.MarslienSoldierEntity;
import net.mcreator.marsrenaissance.entity.MarslienSoldierGunFireProjectileEntity;
import net.mcreator.marsrenaissance.entity.RocketEntity;
import net.mcreator.marsrenaissance.entity.VanhilusEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MarsRenaissanceModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mars_renaissance");
    public static final DeferredHolder<EntityType<?>, EntityType<MarslienEntity>> MARSLIEN = MarsRenaissanceModEntities.register("marslien", EntityType.Builder.of(MarslienEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MarslienSoldierEntity>> MARSLIEN_SOLDIER = MarsRenaissanceModEntities.register("marslien_soldier", EntityType.Builder.of(MarslienSoldierEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MarslienSoldierGunFireProjectileEntity>> MARSLIEN_SOLDIER_GUN_FIRE_PROJECTILE = MarsRenaissanceModEntities.register("marslien_soldier_gun_fire_projectile", EntityType.Builder.of(MarslienSoldierGunFireProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<LaserGunProjectileEntity>> LASER_GUN_PROJECTILE = MarsRenaissanceModEntities.register("laser_gun_projectile", EntityType.Builder.of(LaserGunProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<RocketEntity>> ROCKET = MarsRenaissanceModEntities.register("rocket", EntityType.Builder.of(RocketEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<VanhilusEntity>> VANHILUS = MarsRenaissanceModEntities.register("vanhilus", EntityType.Builder.of(VanhilusEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.6f, 2.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LaserShotgunProjectileEntity>> LASER_SHOTGUN_PROJECTILE = MarsRenaissanceModEntities.register("laser_shotgun_projectile", EntityType.Builder.of(LaserShotgunProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MarslienEntity.init(event);
        MarslienSoldierEntity.init(event);
        VanhilusEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MARSLIEN.get(), MarslienEntity.createAttributes().build());
        event.put((EntityType)MARSLIEN_SOLDIER.get(), MarslienSoldierEntity.createAttributes().build());
        event.put((EntityType)VANHILUS.get(), VanhilusEntity.createAttributes().build());
    }
}

