/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PerfoBoosterCommand {
    private final PerfoBooster plugin;
    private static final Component PLUGIN_NAME_FORMATTED = ((TextComponent)Component.text((String)"PerfoBooster").color(TextColor.color((int)61951))).decorate(TextDecoration.BOLD);
    private static final Component SEPARATOR = Component.text((String)"---------------------------------").color(TextColor.color((int)0x252525));

    public PerfoBoosterCommand(PerfoBooster plugin) {
        this.plugin = plugin;
    }

    private void sendFormattedResponse(CommandSender sender, String title, List<Component> contentLines) {
        String version = this.plugin.getDescription().getVersion();
        Component pluginName = ((TextComponent)Component.text((String)"PerfoBooster").color(TextColor.color((int)61951))).decorate(TextDecoration.BOLD);
        Component versionComponent = ((TextComponent)((TextComponent)Component.text((String)" (").color(TextColor.color((int)0x252525))).append(((TextComponent)Component.text((String)version).color((TextColor)NamedTextColor.WHITE)).decorate(TextDecoration.BOLD))).append(Component.text((String)")").color(TextColor.color((int)0x252525)));
        Component combined = pluginName.append(versionComponent);
        int totalWidth = 31;
        int textWidth = "PerfoBooster".length() + version.length() + 3;
        int padding = (totalWidth - textWidth) / 2;
        Object paddingStr = "";
        for (int i = 0; i < padding; ++i) {
            paddingStr = (String)paddingStr + " ";
        }
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        sender.sendMessage(Component.text((String)paddingStr).append(combined));
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        String titleText = " + " + title + " + ";
        padding = (totalWidth - titleText.length()) / 2;
        paddingStr = "";
        for (int i = 0; i < padding; ++i) {
            paddingStr = (String)paddingStr + " ";
        }
        sender.sendMessage(Component.text((String)((String)paddingStr + titleText)).color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        for (Component line : contentLines) {
            sender.sendMessage(line);
        }
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
    }

    public void sendHelp(CommandSender sender) {
        List<Component> helpLines = Arrays.asList(Component.text((String)"  /pb reload - Reload config").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb status - View status").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb gc - Run GC").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb load - Show server load").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb sysinfo - Show system info").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb update - Check for updates").color((TextColor)NamedTextColor.GRAY), Component.text((String)"  /pb info - Show plugin info").color((TextColor)NamedTextColor.GRAY));
        this.sendFormattedResponse(sender, "Commands Help", helpLines);
    }

    public void handleReload(CommandSender sender) {
        this.plugin.reloadConfig();
        List<Component> lines = Arrays.asList(Component.text((String)"PerfoBooster configuration reloaded successfully!").color((TextColor)NamedTextColor.GREEN));
        this.sendFormattedResponse(sender, "Reload", lines);
    }

    public void handleStatus(CommandSender sender) {
        ArrayList<Component> statusLines = new ArrayList<Component>();
        statusLines.add(((TextComponent)Component.text((String)"Entity Management:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Aggressive Despawning", this.plugin.getConfig().getBoolean("entityManagement.aggressiveDespawning.enabled")));
        statusLines.add(this.formatStatusLine("  Farm Rate Limiting", this.plugin.getConfig().getBoolean("entityManagement.farmRateLimiting.enabled")));
        statusLines.add(this.formatStatusLine("  Disable Mob AI", this.plugin.getConfig().getBoolean("entityManagement.disableMobAI.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Chunk Management:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Unload Inactive Chunks", this.plugin.getConfig().getBoolean("chunkManagement.unloadInactiveChunks.enabled")));
        statusLines.add(this.formatStatusLine("  Chunk Load Control", this.plugin.getConfig().getBoolean("chunkManagement.chunkLoadControl.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Redstone Optimization:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Player Anti-Spam", this.plugin.getConfig().getBoolean("redstoneOptimization.playerAntiSpam.enabled")));
        statusLines.add(this.formatStatusLine("  Redstone Limiter", this.plugin.getConfig().getBoolean("redstoneOptimization.redstoneLimiter.enabled")));
        statusLines.add(this.formatStatusLine("  Deactivate Redstone", this.plugin.getConfig().getBoolean("redstoneOptimization.deactivateRedstone.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Player Network Optimization:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  View Distance Scaling", this.plugin.getConfig().getBoolean("playerNetworkOptimization.viewDistanceScaling.enabled")));
        statusLines.add(this.formatStatusLine("  Idle Simulation Distance", this.plugin.getConfig().getBoolean("playerNetworkOptimization.idleSimulationDistance.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"World Tick Management:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Unload Laggy Chunks", this.plugin.getConfig().getBoolean("worldTickManagement.unloadLaggyChunks.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Memory Performance:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Garbage Collection", this.plugin.getConfig().getBoolean("memoryPerformanceTweaks.garbageCollection.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Block Optimization:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        boolean hopperEnabled = this.plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.enabled", false);
        Component hopperLine = this.formatStatusLine("  Hopper Tweaks", hopperEnabled);
        statusLines.add(hopperLine);
        statusLines.add(this.formatStatusLine("  Adjust Spawner", this.plugin.getConfig().getBoolean("blockOptimization.adjustSpawner.enabled")));
        statusLines.add(this.formatStatusLine("  Instant Leaf Decay", this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.enabled")));
        statusLines.add(((TextComponent)Component.text((String)"Other Features:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        statusLines.add(this.formatStatusLine("  Update Checker", this.plugin.getConfig().getBoolean("updateChecker.enabled")));
        this.sendFormattedResponse(sender, "Plugin Status", statusLines);
    }

    private Component formatStatusLine(String feature, boolean enabled) {
        return ((TextComponent)((TextComponent)Component.text((String)feature).color((TextColor)NamedTextColor.BLUE)).append(Component.text((String)": ").color(TextColor.color((int)0x252525)))).append(Component.text((String)(enabled ? "Enabled" : "Disabled")).color((TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)));
    }

    public void handleGarbageCollection(CommandSender sender) {
        sender.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Attempting to run garbage collection, please wait...").color(TextColor.color((int)0xFFFF00))));
        long beforeMemory = Runtime.getRuntime().freeMemory();
        long startTime = System.currentTimeMillis();
        System.gc();
        long endTime = System.currentTimeMillis();
        long afterMemory = Runtime.getRuntime().freeMemory();
        long memoryFreed = afterMemory - beforeMemory;
        long memoryFreedMB = Math.max(0L, memoryFreed / 1024L / 1024L);
        List<Component> gcLines = Arrays.asList(Component.text((String)"Garbage collection process invoked.").color((TextColor)NamedTextColor.GREEN), ((TextComponent)Component.text((String)"Duration: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(endTime - startTime + "ms")).color((TextColor)NamedTextColor.YELLOW)), ((TextComponent)Component.text((String)"Memory Freed (approx.): ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(memoryFreedMB + " MB")).color((TextColor)NamedTextColor.YELLOW)));
        this.sendFormattedResponse(sender, "Garbage Collection", gcLines);
    }

    public void handleServerLoad(CommandSender sender) {
        sender.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Collecting server load data, please wait...").color(TextColor.color((int)0xFFFF00))));
        ((CompletableFuture)this.collectServerLoadData().thenAccept(loadData -> this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, tasky -> this.displayServerLoad(sender, (ServerLoadData)loadData)))).exceptionally(throwable -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, tasky -> {
                List<Component> errorLines = Arrays.asList(Component.text((String)("Error collecting server load data: " + throwable.getMessage())).color((TextColor)NamedTextColor.RED));
                this.sendFormattedResponse(sender, "Error", errorLines);
                this.plugin.getLogger().warning("Error in showServerLoad: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void displayServerLoad(CommandSender sender, ServerLoadData loadData) {
        Player player;
        ArrayList<Component> loadLines = new ArrayList<Component>();
        loadLines.add(((TextComponent)Component.text((String)"Entities: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)loadData.totalEntities).color((TextColor)NamedTextColor.WHITE)));
        loadLines.add(((TextComponent)Component.text((String)"Tile Entities: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)loadData.totalTileEntities).color((TextColor)NamedTextColor.WHITE)));
        loadLines.add(((TextComponent)Component.text((String)"Loaded Chunks: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)loadData.totalChunks).color((TextColor)NamedTextColor.WHITE)));
        loadLines.add(((TextComponent)Component.text((String)"Online Players: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)loadData.playerCount).color((TextColor)NamedTextColor.WHITE)));
        double globalTps = this.plugin.getTpsMonitor().getGlobalTps();
        double globalMspt = this.plugin.getTpsMonitor().getGlobalMspt();
        loadLines.add(((TextComponent)Component.text((String)"Global TPS: ").color((TextColor)NamedTextColor.GOLD)).append(this.formatTps(globalTps)));
        loadLines.add(Component.text((String)"World Performance:").color((TextColor)NamedTextColor.GOLD));
        for (World world : this.plugin.getServer().getWorlds()) {
            double worldTps = this.plugin.getTpsMonitor().getWorldTps(world);
            double worldMspt = this.plugin.getTpsMonitor().getWorldMspt(world);
            loadLines.add(((TextComponent)Component.text((String)("  " + world.getName() + ": ")).color((TextColor)NamedTextColor.GRAY)).append(this.formatTps(worldTps)));
        }
        if (sender instanceof Player && (player = (Player)sender).isOnline() && player.getWorld() != null) {
            double playerWorldTps = this.plugin.getTpsMonitor().getWorldTps(player.getWorld());
            double playerWorldMspt = this.plugin.getTpsMonitor().getWorldMspt(player.getWorld());
            loadLines.add(((TextComponent)Component.text((String)("Your world (" + player.getWorld().getName() + "): ")).color((TextColor)NamedTextColor.DARK_AQUA)).append(this.formatTps(playerWorldTps)));
        }
        this.sendFormattedResponse(sender, "Server Load", loadLines);
    }

    public void handleSystemInfo(CommandSender sender) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory() / 1024L / 1024L;
        long allocatedMemory = runtime.totalMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long usedMemory = allocatedMemory - freeMemory;
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        double systemLoad = osBean.getSystemLoadAverage();
        int availableProcessors = osBean.getAvailableProcessors();
        File dataFolder = this.plugin.getDataFolder();
        long totalSpace = dataFolder.getTotalSpace() / 1024L / 1024L / 1024L;
        long freeSpace = dataFolder.getFreeSpace() / 1024L / 1024L / 1024L;
        long usedSpace = totalSpace - freeSpace;
        long startTime = System.nanoTime();
        this.plugin.getConfig().getString("dummy_key_for_latency_test", "dummy_value");
        long endTime = System.nanoTime();
        double configAccessTime = (double)(endTime - startTime) / 1000000.0;
        ArrayList<Component> sysInfoLines = new ArrayList<Component>();
        sysInfoLines.add(Component.text((String)"Memory Usage:").color((TextColor)NamedTextColor.AQUA));
        sysInfoLines.add(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  Used: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(usedMemory + " MB")).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" / ").color(TextColor.color((int)0x252525)))).append(Component.text((String)(allocatedMemory + " MB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Free (within allocated): ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(freeMemory + " MB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Max JVM: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(maxMemory + " MB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(Component.text((String)"CPU Information:").color((TextColor)NamedTextColor.AQUA));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Processors: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)availableProcessors).color((TextColor)NamedTextColor.WHITE)));
        if (systemLoad >= 0.0) {
            sysInfoLines.add(((TextComponent)Component.text((String)"  System Load Avg: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)String.format("%.2f", systemLoad)).color((TextColor)NamedTextColor.WHITE)));
        } else {
            sysInfoLines.add(((TextComponent)Component.text((String)"  System Load Avg: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Not available").color((TextColor)NamedTextColor.YELLOW)));
        }
        sysInfoLines.add(Component.text((String)"Storage (Plugin Folder Partition):").color((TextColor)NamedTextColor.AQUA));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Used: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(usedSpace + " GB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Free: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(freeSpace + " GB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Total: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(totalSpace + " GB")).color((TextColor)NamedTextColor.WHITE)));
        sysInfoLines.add(Component.text((String)"Internal Latency:").color((TextColor)NamedTextColor.AQUA));
        sysInfoLines.add(((TextComponent)Component.text((String)"  Config Access: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(String.format("%.2f", configAccessTime) + " ms")).color((TextColor)NamedTextColor.WHITE)));
        this.sendFormattedResponse(sender, "System Information", sysInfoLines);
    }

    public void handleUpdate(CommandSender sender, String[] args) {
        if (!this.plugin.getUpdateChecker().isUpdateCheckerEnabled()) {
            List<Component> lines = Arrays.asList(Component.text((String)"The update checker is currently disabled in the config.").color((TextColor)NamedTextColor.RED));
            this.sendFormattedResponse(sender, "Update Information", lines);
            return;
        }
        if (args.length > 1) {
            String subCommand;
            switch (subCommand = args[1].toLowerCase()) {
                case "check": {
                    sender.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Checking for updates, please wait...").color(TextColor.color((int)0xFFFF00))));
                    this.plugin.getUpdateChecker().forceUpdateCheck(sender);
                    break;
                }
                case "download": {
                    if (!sender.hasPermission("perfobooster.admin")) {
                        sender.sendMessage(this.plugin.getPrefix().append(Component.text((String)"You need admin permission to download updates!").color(TextColor.color((int)0xFF0000))));
                        return;
                    }
                    this.plugin.getUpdateChecker().downloadUpdate(sender);
                    break;
                }
                default: {
                    this.plugin.getUpdateChecker().displayUpdateInfo(sender);
                    break;
                }
            }
        } else {
            this.plugin.getUpdateChecker().displayUpdateInfo(sender);
        }
    }

    public void handleInfo(CommandSender sender) {
        ArrayList<Component> infoLines = new ArrayList<Component>();
        infoLines.add(((TextComponent)Component.text((String)"Plugin Information:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        infoLines.add(((TextComponent)Component.text((String)"  Name: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getDescription().getName()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"  Version: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getDescription().getVersion()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"  Description: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getDescription().getDescription()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"  Authors: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)String.join((CharSequence)", ", this.plugin.getDescription().getAuthors())).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"Server Information:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        infoLines.add(((TextComponent)Component.text((String)"  Server: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getServer().getName()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"  Version: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getServer().getVersion()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"Performance Summary:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        double globalTps = this.plugin.getTpsMonitor().getGlobalTps();
        infoLines.add(((TextComponent)Component.text((String)"  Global TPS: ").color((TextColor)NamedTextColor.GRAY)).append(this.formatTps(globalTps)));
        infoLines.add(((TextComponent)Component.text((String)"  Online Players: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)this.plugin.getServer().getOnlinePlayers().size()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"  Worlds: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)this.plugin.getServer().getWorlds().size()).color((TextColor)NamedTextColor.WHITE)));
        infoLines.add(((TextComponent)Component.text((String)"Update Status:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        if (this.plugin.getUpdateChecker().isUpdateAvailable()) {
            infoLines.add(((TextComponent)Component.text((String)"  Status: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Update Available!").color((TextColor)NamedTextColor.RED)));
            infoLines.add(((TextComponent)Component.text((String)"  Latest Version: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getUpdateChecker().getLatestVersion()).color((TextColor)NamedTextColor.GREEN)));
        } else {
            infoLines.add(((TextComponent)Component.text((String)"  Status: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Up to date").color((TextColor)NamedTextColor.GREEN)));
        }
        infoLines.add(((TextComponent)Component.text((String)"Links:").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        infoLines.add(((TextComponent)Component.text((String)"  Discord: ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"https://discord.gg/yUghaxRSZs").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)));
        infoLines.add(((TextComponent)Component.text((String)"  Modrinth: ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"https://modrinth.com/plugin/perfobooster").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)));
        this.sendFormattedResponse(sender, "Plugin Information", infoLines);
    }

    private CompletableFuture<ServerLoadData> collectServerLoadData() {
        CompletableFuture<ServerLoadData> future = new CompletableFuture<ServerLoadData>();
        ServerLoadData loadData = new ServerLoadData();
        loadData.playerCount = this.plugin.getServer().getOnlinePlayers().size();
        AtomicInteger worldsProcessed = new AtomicInteger(0);
        ArrayList worlds = new ArrayList(this.plugin.getServer().getWorlds());
        int totalWorlds = worlds.size();
        if (totalWorlds == 0) {
            future.complete(loadData);
            return future;
        }
        for (World world : worlds) {
            try {
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world.getSpawnLocation(), () -> {
                    block9: {
                        try {
                            int worldEntities = world.getEntities().size();
                            int worldTileEntities = 0;
                            int worldChunks = 0;
                            Chunk[] loadedChunks = world.getLoadedChunks();
                            worldChunks = loadedChunks.length;
                            for (Chunk chunk : loadedChunks) {
                                try {
                                    worldTileEntities += chunk.getTileEntities().length;
                                }
                                catch (Exception e) {
                                    this.plugin.getLogger().warning("Could not access tile entities for chunk in world " + world.getName());
                                }
                            }
                            ServerLoadData serverLoadData = loadData;
                            synchronized (serverLoadData) {
                                loadData.totalEntities += worldEntities;
                                loadData.totalTileEntities += worldTileEntities;
                                loadData.totalChunks += worldChunks;
                            }
                            if (worldsProcessed.incrementAndGet() >= totalWorlds) {
                                future.complete(loadData);
                            }
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error collecting data for world " + world.getName() + ": " + e.getMessage());
                            if (worldsProcessed.incrementAndGet() < totalWorlds) break block9;
                            future.complete(loadData);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error scheduling data collection for world " + world.getName() + ": " + e.getMessage());
                if (worldsProcessed.incrementAndGet() < totalWorlds) continue;
                future.complete(loadData);
            }
        }
        return future;
    }

    private Component formatTps(double tps) {
        String formattedTps = String.format("%.1f TPS", tps);
        if (tps >= 18.0) {
            return Component.text((String)formattedTps).color((TextColor)NamedTextColor.GREEN);
        }
        if (tps >= 15.0) {
            return Component.text((String)formattedTps).color((TextColor)NamedTextColor.YELLOW);
        }
        return Component.text((String)formattedTps).color((TextColor)NamedTextColor.RED);
    }

    private Component formatMspt(double mspt) {
        String formattedMspt = String.format("%.2f MSPT", mspt);
        if (mspt <= 45.0) {
            return Component.text((String)formattedMspt).color((TextColor)NamedTextColor.GREEN);
        }
        if (mspt <= 55.0) {
            return Component.text((String)formattedMspt).color((TextColor)NamedTextColor.YELLOW);
        }
        return Component.text((String)formattedMspt).color((TextColor)NamedTextColor.RED);
    }

    private static class ServerLoadData {
        int totalEntities = 0;
        int totalTileEntities = 0;
        int totalChunks = 0;
        int playerCount = 0;

        private ServerLoadData() {
        }
    }
}

