/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.entity;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class AggressiveDespawner
implements Listener {
    private final PerfoBooster plugin;
    private final Set<EntityType> targetEntityTypes = new HashSet<EntityType>();
    private int despawnRange;
    private int checkInterval;
    private boolean ignoreNametag;
    private boolean enabled;
    private DespawnMode despawnMode;
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public AggressiveDespawner(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startCleanupTask();
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("entityManagement.aggressiveDespawning.enabled", true);
        if (!this.enabled) {
            return;
        }
        this.targetEntityTypes.clear();
        List entityTypeNames = this.plugin.getConfig().getStringList("entityManagement.aggressiveDespawning.entityTypes");
        for (String name : entityTypeNames) {
            try {
                EntityType type = EntityType.valueOf((String)name.toUpperCase());
                this.targetEntityTypes.add(type);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid entity type in config for aggressiveDespawning: " + name)).color(TextColor.color((int)0xFF0000))));
            }
        }
        String modeString = this.plugin.getConfig().getString("entityManagement.aggressiveDespawning.despawnMode", "REMOVE");
        try {
            this.despawnMode = DespawnMode.valueOf(modeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid despawn mode in config: " + modeString + ". Using REMOVE as default.")).color(TextColor.color((int)0xFFFF00))));
            this.despawnMode = DespawnMode.REMOVE;
        }
        this.ignoreNametag = this.plugin.getConfig().getBoolean("entityManagement.aggressiveDespawning.ignoreNamedEntities", true);
        this.despawnRange = this.plugin.getConfig().getInt("entityManagement.aggressiveDespawning.despawnRange", 64);
        this.checkInterval = this.plugin.getConfig().getInt("entityManagement.aggressiveDespawning.checkInterval", 10);
    }

    private void startCleanupTask() {
        if (!this.enabled) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            Location spawnLocation = world.getSpawnLocation();
            if (spawnLocation == null) {
                spawnLocation = new Location(world, 0.0, 64.0, 0.0);
            }
            ScheduledTask task = this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, spawnLocation, schedulerTask -> this.cleanupEntitiesInRegion(world), 100L, (long)this.checkInterval * 20L);
            this.scheduledTasks.add(task);
        }
    }

    private void cleanupEntitiesInRegion(World world) {
        if (!this.enabled || world.getPlayers().isEmpty()) {
            return;
        }
        ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
        for (Entity entity : world.getEntities()) {
            if (entity.getType() == EntityType.ITEM || entity.isPersistent() || entity.isInvulnerable()) continue;
            boolean shouldProcess = false;
            switch (this.despawnMode.ordinal()) {
                case 0: {
                    shouldProcess = this.targetEntityTypes.contains(entity.getType());
                    break;
                }
                case 1: {
                    boolean bl = shouldProcess = !this.targetEntityTypes.contains(entity.getType());
                }
            }
            if (!shouldProcess) continue;
            if (this.ignoreNametag && entity.getCustomName() != null && !entity.getCustomName().isEmpty()) {
                shouldProcess = false;
            }
            if (shouldProcess) {
                boolean playerNearby = false;
                for (Player player : world.getPlayers()) {
                    Location playerLoc;
                    if (!player.isOnline() || (playerLoc = player.getLocation()).getWorld() == null || !playerLoc.getWorld().equals((Object)world) || !(entity.getLocation().distanceSquared(playerLoc) <= (double)(this.despawnRange * this.despawnRange))) continue;
                    playerNearby = true;
                    break;
                }
                if (playerNearby) {
                    shouldProcess = false;
                }
            }
            if (!shouldProcess) continue;
            entitiesToRemove.add(entity);
        }
        for (Entity entity : entitiesToRemove) {
            this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, entity.getLocation(), () -> ((Entity)entity).remove());
        }
    }

    public void shutdown() {
        for (ScheduledTask task : this.scheduledTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.scheduledTasks.clear();
        this.targetEntityTypes.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DespawnMode getDespawnMode() {
        return this.despawnMode;
    }

    public static enum DespawnMode {
        REMOVE,
        KEEP;

    }
}

