/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.entity;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class DisableMobAI
implements Listener {
    private final PerfoBooster plugin;
    private final Set<EntityType> targetEntityTypes = new HashSet<EntityType>();
    private boolean enabled;
    private int checkInterval;
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public DisableMobAI(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startAIDisableTask();
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("entityManagement.disableMobAI.enabled", true);
        if (!this.enabled) {
            return;
        }
        this.targetEntityTypes.clear();
        List entityTypeNames = this.plugin.getConfig().getStringList("entityManagement.disableMobAI.entityTypes");
        for (String name : entityTypeNames) {
            try {
                EntityType type = EntityType.valueOf((String)name.toUpperCase());
                this.targetEntityTypes.add(type);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid entity type in config for disableMobAI: " + name)).color(TextColor.color((int)0xFF0000))));
            }
        }
        this.checkInterval = this.plugin.getConfig().getInt("entityManagement.disableMobAI.checkInterval", 60);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.enabled) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = entity;
        if (this.targetEntityTypes.contains(entity.getType()) && livingEntity.hasAI()) {
            livingEntity.setAI(false);
        }
    }

    private void startAIDisableTask() {
        if (!this.enabled) {
            return;
        }
        ScheduledTask task = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, schedulerTask -> {
            for (World world : Bukkit.getWorlds()) {
                this.processWorldEntities(world);
            }
        }, 200L, (long)this.checkInterval * 20L);
        this.scheduledTasks.add(task);
    }

    private void processWorldEntities(World world) {
        if (!this.enabled) {
            return;
        }
        List worldEntities = world.getEntities();
        for (Entity entity : worldEntities) {
            if (!(entity instanceof LivingEntity) || !this.targetEntityTypes.contains(entity.getType())) continue;
            this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, entity.getLocation(), () -> this.disableEntityAI((LivingEntity)entity));
        }
    }

    private void disableEntityAI(LivingEntity entity) {
        try {
            if (entity.isValid() && entity.hasAI()) {
                entity.setAI(false);
            }
        }
        catch (Exception e) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Error disabling AI for entity " + String.valueOf(entity.getType()) + ": " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
        }
    }

    public void shutdown() {
        for (ScheduledTask task : this.scheduledTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.scheduledTasks.clear();
        this.targetEntityTypes.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<EntityType> getTargetEntityTypes() {
        return new HashSet<EntityType>(this.targetEntityTypes);
    }

    public int getProcessedEntitiesCount() {
        if (!this.enabled) {
            return 0;
        }
        return -1;
    }
}

