/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.network;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.TreeMap;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ViewDistanceScaler
implements Listener {
    private final PerfoBooster plugin;
    private ScheduledTask task;
    private boolean viewDistanceScalingEnabled;
    private final TreeMap<Double, Integer> tpsThresholds = new TreeMap();
    private int defaultViewDistance;
    private AdjustMode adjustMode;

    public ViewDistanceScaler(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.viewDistanceScalingEnabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startViewDistanceTask();
        }
    }

    private void loadConfig() {
        this.viewDistanceScalingEnabled = this.plugin.getConfig().getBoolean("playerNetworkOptimization.viewDistanceScaling.enabled", true);
        if (!this.viewDistanceScalingEnabled) {
            return;
        }
        this.defaultViewDistance = this.plugin.getConfig().getInt("playerNetworkOptimization.viewDistanceScaling.defaultViewDistance", 10);
        String adjustModeStr = this.plugin.getConfig().getString("playerNetworkOptimization.viewDistanceScaling.adjustMode", "WORLD");
        try {
            this.adjustMode = AdjustMode.valueOf(adjustModeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid adjustMode in view distance config: " + adjustModeStr + ". Using WORLD mode.")).color(TextColor.color((int)0xFF0000))));
            this.adjustMode = AdjustMode.WORLD;
        }
        this.tpsThresholds.clear();
        if (this.plugin.getConfig().isConfigurationSection("playerNetworkOptimization.viewDistanceScaling.tpsThresholds")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("playerNetworkOptimization.viewDistanceScaling.tpsThresholds").getKeys(false)) {
                try {
                    double tpsThreshold = Double.parseDouble(key);
                    int viewDistance = this.plugin.getConfig().getInt("playerNetworkOptimization.viewDistanceScaling.tpsThresholds." + key);
                    this.tpsThresholds.put(tpsThreshold, viewDistance);
                }
                catch (NumberFormatException e) {
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid TPS threshold in view distance config: " + key)).color(TextColor.color((int)0xFF0000))));
                }
            }
        }
        if (this.tpsThresholds.isEmpty()) {
            this.tpsThresholds.put(20.0, 12);
            this.tpsThresholds.put(18.0, 10);
            this.tpsThresholds.put(15.0, 8);
            this.tpsThresholds.put(12.0, 6);
            this.tpsThresholds.put(9.0, 4);
            this.tpsThresholds.put(0.0, 2);
        }
    }

    private void startViewDistanceTask() {
        if (!this.viewDistanceScalingEnabled) {
            return;
        }
        this.task = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.adjustViewDistanceBasedOnTPS(), 200L, 200L);
    }

    private void adjustViewDistanceBasedOnTPS() {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        double currentTPS = this.plugin.getTpsMonitor().getGlobalTps();
        int newViewDistance = this.getViewDistanceForTPS(currentTPS);
        if (this.adjustMode == AdjustMode.WORLD) {
            this.plugin.getServer().getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                for (World world : Bukkit.getWorlds()) {
                    if (world.getViewDistance() == newViewDistance) continue;
                    world.setViewDistance(newViewDistance);
                }
            });
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOnline()) continue;
                Player finalPlayer = player;
                int finalViewDistance = newViewDistance;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, player.getLocation(), () -> {
                    if (finalPlayer.isOnline() && finalPlayer.getViewDistance() != finalViewDistance) {
                        finalPlayer.setViewDistance(finalViewDistance);
                    }
                });
            }
        }
    }

    private int getViewDistanceForTPS(double tps) {
        Map.Entry<Double, Integer> entry = this.tpsThresholds.floorEntry(tps);
        if (entry != null) {
            return entry.getValue();
        }
        if (!this.tpsThresholds.isEmpty()) {
            return this.tpsThresholds.lastEntry().getValue();
        }
        return this.defaultViewDistance;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.viewDistanceScalingEnabled) {
            double currentTPS = this.plugin.getTpsMonitor().getGlobalTps();
            int viewDistance = this.getViewDistanceForTPS(currentTPS);
            if (this.adjustMode == AdjustMode.PLAYER) {
                event.getPlayer().setViewDistance(viewDistance);
            }
        }
    }

    public void shutdown() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        this.tpsThresholds.clear();
    }

    public boolean isEnabled() {
        return this.viewDistanceScalingEnabled;
    }

    public static enum AdjustMode {
        WORLD,
        PLAYER;

    }
}

