/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    private final PerfoBooster plugin;
    private final String configFileName;
    private final Map<String, List<String>> commentsMap = new LinkedHashMap<String, List<String>>();
    private final Set<String> knownKeys = new LinkedHashSet<String>();
    private final Set<String> listKeys = new LinkedHashSet<String>();
    private final List<String> topLevelKeyOrder = new ArrayList<String>();

    public ConfigUpdater(PerfoBooster plugin, String configFileName) {
        this.plugin = plugin;
        this.configFileName = configFileName;
        this.loadDefaultConfig();
    }

    private void loadDefaultConfig() {
        try {
            InputStream defaultConfigStream = this.plugin.getResource(this.configFileName);
            if (defaultConfigStream == null) {
                this.plugin.getLogger().warning("Could not find default " + this.configFileName + " in plugin resources!");
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(defaultConfigStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            this.parseCommentsAndKeys(lines);
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource(this.configFileName), StandardCharsets.UTF_8));
            this.collectAllKeys((ConfigurationSection)defaultConfig, "");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load default config: " + e.getMessage());
        }
    }

    private void parseCommentsAndKeys(List<String> lines) {
        ArrayList<String> currentComments = new ArrayList<String>();
        ArrayList<String> headerComments = new ArrayList<String>();
        String currentPath = "";
        int currentIndentation = 0;
        HashMap<Integer, Object> indentationToPath = new HashMap<Integer, Object>();
        boolean inList = false;
        boolean headerProcessed = false;
        for (String line : lines) {
            int indentation;
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                if (!headerProcessed) {
                    headerComments.add("");
                    continue;
                }
                if (currentComments.isEmpty()) continue;
                currentComments.add("");
                continue;
            }
            if (trimmedLine.startsWith("#")) {
                if (!headerProcessed) {
                    headerComments.add(line);
                    continue;
                }
                currentComments.add(line);
                continue;
            }
            if (!headerProcessed) {
                headerProcessed = true;
                if (!headerComments.isEmpty()) {
                    this.commentsMap.put("__HEADER__", new ArrayList(headerComments));
                }
            }
            if (trimmedLine.startsWith("-")) {
                inList = true;
                continue;
            }
            if (inList && !trimmedLine.startsWith("-") && (indentation = this.getIndentation(line)) <= currentIndentation) {
                inList = false;
            }
            if (!trimmedLine.contains(":")) continue;
            indentation = this.getIndentation(line);
            String key = trimmedLine.split(":", 2)[0].trim();
            if (indentation > currentIndentation) {
                indentationToPath.put(indentation, currentPath.isEmpty() ? key : currentPath + "." + key);
            } else if (indentation < currentIndentation) {
                String parentPath = indentationToPath.getOrDefault(indentation, "");
                if (!parentPath.isEmpty()) {
                    int lastDot = parentPath.lastIndexOf(46);
                    if (lastDot != -1) {
                        currentPath = parentPath.substring(0, lastDot);
                        indentationToPath.put(indentation, currentPath.isEmpty() ? key : currentPath + "." + key);
                    } else {
                        currentPath = "";
                        indentationToPath.put(indentation, key);
                    }
                } else {
                    currentPath = "";
                    indentationToPath.put(indentation, key);
                }
            } else {
                if (!currentPath.isEmpty()) {
                    int lastDot = currentPath.lastIndexOf(46);
                    currentPath = lastDot != -1 ? currentPath.substring(0, lastDot) : "";
                }
                indentationToPath.put(indentation, currentPath.isEmpty() ? key : currentPath + "." + key);
            }
            currentIndentation = indentation;
            currentPath = (String)indentationToPath.get(indentation);
            if (indentation == 0 && !this.topLevelKeyOrder.contains(key)) {
                this.topLevelKeyOrder.add(key);
            }
            boolean isList = trimmedLine.endsWith(":");
            String nextLine = "";
            for (int i = lines.indexOf(line) + 1; i < lines.size() && ((nextLine = lines.get(i).trim()).isEmpty() || nextLine.startsWith("#")); ++i) {
            }
            if (isList && nextLine.startsWith("-")) {
                this.listKeys.add(currentPath);
            }
            if (!currentComments.isEmpty()) {
                this.commentsMap.put(currentPath, new ArrayList(currentComments));
                currentComments.clear();
            }
            this.knownKeys.add(currentPath);
        }
    }

    private int getIndentation(String line) {
        int count = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++count;
        }
        return count;
    }

    private void collectAllKeys(ConfigurationSection section, String parentPath) {
        for (String key : section.getKeys(false)) {
            String fullPath = parentPath.isEmpty() ? key : parentPath + "." + key;
            this.knownKeys.add(fullPath);
            if (section.isList(key)) {
                this.listKeys.add(fullPath);
            }
            if (!section.isConfigurationSection(key)) continue;
            this.collectAllKeys(section.getConfigurationSection(key), fullPath);
        }
    }

    public boolean update() {
        try {
            YamlConfiguration userConfig;
            File configFile = new File(this.plugin.getDataFolder(), this.configFileName);
            if (!configFile.exists()) {
                this.plugin.saveDefaultConfig();
                return true;
            }
            try {
                userConfig = YamlConfiguration.loadConfiguration((File)configFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Config file is invalid. Creating backup and using default. Error: " + e.getMessage());
                this.backupConfig(configFile);
                this.plugin.saveResource(this.configFileName, true);
                return true;
            }
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource(this.configFileName), StandardCharsets.UTF_8));
            boolean updated = false;
            for (Object key : defaultConfig.getKeys(true)) {
                if (userConfig.contains((String)key) || defaultConfig.isConfigurationSection((String)key)) continue;
                userConfig.set(key, defaultConfig.get(key));
                updated = true;
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Added missing config option: ").color(TextColor.color((int)65280))).append(Component.text(key).color(TextColor.color((int)0xFFFFFF))));
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : userConfig.getKeys(true)) {
                if (this.knownKeys.contains(key) || defaultConfig.contains(key) || defaultConfig.isConfigurationSection(key)) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                userConfig.set(key, null);
                updated = true;
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Removed unknown config option: ").color(TextColor.color((int)0xFFFF00))).append(Component.text((String)key).color(TextColor.color((int)0xFFFFFF))));
            }
            if (updated) {
                this.backupConfig(configFile);
                String updatedConfig = this.generateUpdatedConfig(userConfig, defaultConfig);
                Files.writeString(configFile.toPath(), (CharSequence)updatedConfig, StandardCharsets.UTF_8, new OpenOption[0]);
                this.plugin.reloadConfig();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to update config: " + e.getMessage());
            return false;
        }
    }

    private String generateUpdatedConfig(YamlConfiguration userConfig, YamlConfiguration defaultConfig) {
        StringBuilder builder = new StringBuilder();
        List<String> headerComments = this.commentsMap.get("__HEADER__");
        if (headerComments != null) {
            for (String comment : headerComments) {
                if (!comment.trim().isEmpty()) {
                    builder.append(comment).append("\n");
                    continue;
                }
                builder.append("\n");
            }
            if (!headerComments.isEmpty()) {
                builder.append("\n");
            }
        }
        for (String topKey : this.topLevelKeyOrder) {
            if (!this.knownKeys.contains(topKey)) continue;
            this.writeConfigSection(builder, userConfig, defaultConfig, topKey, "", 0);
        }
        return builder.toString();
    }

    private void writeConfigSection(StringBuilder builder, YamlConfiguration userConfig, YamlConfiguration defaultConfig, String key, String parentPath, int indentLevel) {
        String fullPath = parentPath.isEmpty() ? key : parentPath + "." + key;
        String spaces = " ".repeat(indentLevel * 2);
        List<String> comments = this.commentsMap.get(fullPath);
        if (comments != null && !comments.isEmpty()) {
            if (builder.length() > 0 && !builder.toString().endsWith("\n\n") && indentLevel == 0) {
                builder.append("\n");
            }
            for (String comment : comments) {
                if (!comment.trim().isEmpty()) {
                    String originalComment = comment.startsWith("#") ? comment : comment.trim();
                    builder.append(spaces).append(originalComment).append("\n");
                    continue;
                }
                builder.append("\n");
            }
        }
        if (defaultConfig.isConfigurationSection(fullPath) || userConfig.isConfigurationSection(fullPath)) {
            Object userSection;
            builder.append(spaces).append(key).append(":\n");
            LinkedHashSet childKeys = new LinkedHashSet();
            ConfigurationSection defaultSection = defaultConfig.getConfigurationSection(fullPath);
            if (defaultSection != null) {
                childKeys.addAll(defaultSection.getKeys(false));
            }
            if ((userSection = userConfig.getConfigurationSection(fullPath)) != null) {
                childKeys.addAll(userSection.getKeys(false));
            }
            for (String childKey : childKeys) {
                this.writeConfigSection(builder, userConfig, defaultConfig, childKey, fullPath, indentLevel + 1);
            }
        } else if (this.listKeys.contains(fullPath)) {
            builder.append(spaces).append(key).append(":");
            List list = userConfig.getList(fullPath);
            if (list == null || list.isEmpty()) {
                List defaultList = defaultConfig.getList(fullPath);
                if (defaultList == null || defaultList.isEmpty()) {
                    builder.append(" []\n");
                } else {
                    builder.append("\n");
                    for (Object item : defaultList) {
                        builder.append(spaces).append("  - ").append(this.formatValue(item)).append("\n");
                    }
                }
            } else {
                builder.append("\n");
                for (Object item : list) {
                    builder.append(spaces).append("  - ").append(this.formatValue(item)).append("\n");
                }
            }
        } else {
            Object value = userConfig.get(fullPath, defaultConfig.get(fullPath));
            builder.append(spaces).append(key).append(": ").append(this.formatValue(value)).append("\n");
        }
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || str.contains(":") || str.contains("#") || str.contains("'") || str.contains("\"") || str.contains("\n") || str.matches("\\d+\\.\\d+") || str.matches("\\d+")) {
                return "\"" + str.replace("\"", "\\\"") + "\"";
            }
            return str;
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof List) {
            return "[]";
        }
        return value.toString();
    }

    private void backupConfig(File configFile) throws IOException {
        if (!configFile.exists()) {
            return;
        }
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists() && !backupDir.mkdirs()) {
            this.plugin.getLogger().warning("Could not create backups directory!");
            return;
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        File backupFile = new File(backupDir, this.configFileName + "." + timestamp + ".tmp");
        Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
    }

    public Set<String> getKnownKeys() {
        return Collections.unmodifiableSet(this.knownKeys);
    }

    public Map<String, List<String>> getCommentsMap() {
        return Collections.unmodifiableMap(this.commentsMap);
    }
}

