/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final PerfoBooster plugin;
    private String latestVersion = null;
    private String downloadUrl = null;
    private ScheduledTask updateTask;
    private ScheduledTask autoUpdateTask;
    private volatile boolean isDownloading = false;
    private static final Component PLUGIN_PREFIX = ((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0x252525))).append(((TextComponent)Component.text((String)"PerfoBooster").color(TextColor.color((int)61951))).decorate(TextDecoration.BOLD))).append(Component.text((String)"] ").color(TextColor.color((int)0x252525)));
    private static final Component SEPARATOR = Component.text((String)"---------------------------------").color(TextColor.color((int)0x252525));

    public UpdateChecker(PerfoBooster plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        if (this.isUpdateCheckerEnabled()) {
            this.startPeriodicCheck();
            this.checkUpdate(true);
            if (this.isAutoUpdateEnabled()) {
                this.startAutoUpdateCheck();
            }
        }
    }

    private void startPeriodicCheck() {
        int checkInterval = this.plugin.getConfig().getInt("updateChecker.checkIntervalHours", 6);
        this.updateTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.checkUpdate(false), TimeUnit.MINUTES.toMillis(5L), TimeUnit.HOURS.toMillis(checkInterval), TimeUnit.MILLISECONDS);
    }

    private void startAutoUpdateCheck() {
        int autoUpdateInterval = this.plugin.getConfig().getInt("updateChecker.autoUpdate.updateCheckInterval", 24);
        this.autoUpdateTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.checkUpdateForAutoUpdate(), TimeUnit.HOURS.toMillis(1L), TimeUnit.HOURS.toMillis(autoUpdateInterval), TimeUnit.MILLISECONDS);
    }

    private void checkUpdateForAutoUpdate() {
        if (!this.isAutoUpdateEnabled() || this.isDownloading) {
            return;
        }
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/perfobooster/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "PerfoBooster/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(10000);
                JsonArray versions = JsonParser.parseReader((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonArray();
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionNumber = version.get("version_number").getAsString();
                    String versionType = version.has("version_type") ? version.get("version_type").getAsString() : "release";
                    if (!this.shouldCheckVersionType(versionType) || !this.isNewerByDate(version, this.plugin.getDescription().getVersion(), versions)) continue;
                    String newDownloadUrl = version.getAsJsonArray("files").get(0).getAsJsonObject().get("url").getAsString();
                    this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Auto-update: New version " + versionNumber + " found! Starting download...")).color(TextColor.color((int)65280))));
                    Component autoUpdateMessage = PLUGIN_PREFIX.append(Component.text((String)("Auto-update: Downloading version " + versionNumber + "...")).color((TextColor)NamedTextColor.YELLOW));
                    this.plugin.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission("perfobooster.admin") || player.isOp()).forEach(player -> player.sendMessage(autoUpdateMessage));
                    this.downloadAndInstallUpdate(newDownloadUrl, versionNumber, true);
                    break;
                }
            }
            catch (Exception e) {
                this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Auto-update check failed: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
            }
        });
    }

    public void downloadUpdate(CommandSender sender) {
        if (this.isDownloading) {
            sender.sendMessage(PLUGIN_PREFIX.append(Component.text((String)"A download is already in progress!").color((TextColor)NamedTextColor.RED)));
            return;
        }
        if (this.latestVersion == null || this.downloadUrl == null) {
            sender.sendMessage(PLUGIN_PREFIX.append(Component.text((String)"No update available to download!").color((TextColor)NamedTextColor.RED)));
            return;
        }
        sender.sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Starting download of version " + this.latestVersion + "...")).color((TextColor)NamedTextColor.YELLOW)));
        this.downloadAndInstallUpdate(this.downloadUrl, this.latestVersion, false);
    }

    private void downloadAndInstallUpdate(String downloadUrl, String version, boolean isAutoUpdate) {
        if (this.isDownloading) {
            return;
        }
        this.isDownloading = true;
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            try {
                Object jarName = this.plugin.getConfig().getString("updateChecker.autoUpdate.jarName", "");
                if (((String)jarName).isEmpty()) {
                    jarName = new File(((Object)((Object)this.plugin)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
                }
                if (!((String)jarName).endsWith(".jar")) {
                    jarName = (String)jarName + ".jar";
                }
                File pluginsFolder = this.plugin.getDataFolder().getParentFile();
                File tempFile = new File(pluginsFolder, (String)jarName + ".tmp");
                File finalFile = new File(pluginsFolder, (String)jarName);
                URL url = new URL(downloadUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "PerfoBooster/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(30000);
                try (InputStream inputStream = connection.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    long totalBytes = 0L;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                        totalBytes += (long)bytesRead;
                    }
                    this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Downloaded " + totalBytes / 1024L + " KB successfully!")).color(TextColor.color((int)65280))));
                }
                Files.move(tempFile.toPath(), finalFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Update " + version + " installed successfully!")).color(TextColor.color((int)65280))));
                Component successMessage = PLUGIN_PREFIX.append(Component.text((String)("Update " + version + " downloaded and installed!")).color((TextColor)NamedTextColor.GREEN));
                this.plugin.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission("perfobooster.admin") || player.isOp()).forEach(player -> player.sendMessage(successMessage));
                if (isAutoUpdate) {
                    this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)"Auto-update: Update downloaded successfully! Please restart the server to apply the changes.").color(TextColor.color((int)0xFFFF00))));
                    Component restartMessage = PLUGIN_PREFIX.append(((TextComponent)Component.text((String)"Update downloaded! Server restart required to apply changes.").color((TextColor)NamedTextColor.YELLOW)).decorate(TextDecoration.BOLD));
                    this.plugin.getServer().getOnlinePlayers().forEach(player -> player.sendMessage(restartMessage));
                    Component adminMessage = PLUGIN_PREFIX.append(Component.text((String)"Please restart the server when convenient to apply the update.").color((TextColor)NamedTextColor.AQUA));
                    this.plugin.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission("perfobooster.admin") || player.isOp()).forEach(player -> player.sendMessage(adminMessage));
                }
            }
            catch (Exception e) {
                this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Download failed: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
                this.plugin.getLogger().severe("Update download failed: " + e.getMessage());
            }
            finally {
                this.isDownloading = false;
            }
        });
    }

    public void checkUpdate(boolean notifyConsole) {
        if (!this.isUpdateCheckerEnabled()) {
            return;
        }
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            block5: {
                try {
                    URL url = new URL("https://api.modrinth.com/v2/project/perfobooster/version");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", "PerfoBooster/" + this.plugin.getDescription().getVersion());
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(10000);
                    JsonArray versions = JsonParser.parseReader((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonArray();
                    for (JsonElement element : versions) {
                        JsonObject version = element.getAsJsonObject();
                        String versionNumber = version.get("version_number").getAsString();
                        String versionType = version.has("version_type") ? version.get("version_type").getAsString() : "release";
                        if (!this.shouldCheckVersionType(versionType) || !this.isNewerByDate(version, this.plugin.getDescription().getVersion(), versions)) continue;
                        this.latestVersion = versionNumber;
                        this.downloadUrl = version.getAsJsonArray("files").get(0).getAsJsonObject().get("url").getAsString();
                        if (notifyConsole) {
                            this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("New version available: " + this.latestVersion + " (Current: " + this.plugin.getDescription().getVersion() + ")")).color(TextColor.color((int)65280))));
                            this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(((TextComponent)Component.text((String)("Download: https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)).color(TextColor.color((int)0xFFFF00))).clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)))));
                        }
                        if (this.isAlertOnAdminJoinEnabled()) {
                            this.notifyOnlineAdmins();
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    if (!notifyConsole) break block5;
                    this.plugin.getServer().getConsoleSender().sendMessage(PLUGIN_PREFIX.append(Component.text((String)("Failed to check for updates: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
                }
            }
        });
    }

    private boolean shouldCheckVersionType(String versionType) {
        switch (versionType.toLowerCase()) {
            case "alpha": {
                return !this.isIgnoreAlpha();
            }
            case "beta": {
                return !this.isIgnoreBeta();
            }
        }
        return true;
    }

    private boolean isNewerByDate(JsonObject newVersion, String currentVersion, JsonArray allVersions) {
        try {
            String newDateStr = newVersion.get("date_published").getAsString();
            Instant newVersionDate = Instant.parse(newDateStr);
            Instant currentVersionDate = null;
            for (JsonElement element : allVersions) {
                JsonObject version = element.getAsJsonObject();
                String versionNumber = version.get("version_number").getAsString();
                if (!versionNumber.equals(currentVersion)) continue;
                String currentDateStr = version.get("date_published").getAsString();
                currentVersionDate = Instant.parse(currentDateStr);
                break;
            }
            if (currentVersionDate == null) {
                return true;
            }
            return newVersionDate.isAfter(currentVersionDate);
        }
        catch (Exception e) {
            return this.isNewer(newVersion.get("version_number").getAsString(), currentVersion);
        }
    }

    private boolean isNewer(String newVersion, String currentVersion) {
        String[] current = currentVersion.replaceAll("[^0-9.]", "").split("\\.");
        String[] newer = newVersion.replaceAll("[^0-9.]", "").split("\\.");
        for (int i = 0; i < Math.min(current.length, newer.length); ++i) {
            int currentPart = Integer.parseInt(current[i]);
            int newerPart = Integer.parseInt(newer[i]);
            if (newerPart > currentPart) {
                return true;
            }
            if (newerPart >= currentPart) continue;
            return false;
        }
        return newer.length > current.length;
    }

    private void notifyOnlineAdmins() {
        Component message = PLUGIN_PREFIX.append(Component.text((String)"Update available! ").color((TextColor)NamedTextColor.YELLOW)).append(((TextComponent)Component.text((String)("v" + this.latestVersion)).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)))).append(Component.text((String)(" (Current: v" + this.plugin.getDescription().getVersion() + ")")).color((TextColor)NamedTextColor.GRAY));
        this.plugin.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission("perfobooster.admin") || player.isOp()).forEach(player -> player.sendMessage(message));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if ((player.isOp() || player.hasPermission("perfobooster.admin")) && this.latestVersion != null && this.isUpdateCheckerEnabled() && this.isAlertOnAdminJoinEnabled() && this.latestVersion != null) {
            this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
                if (!player.isOnline()) {
                    return;
                }
                player.sendMessage(PLUGIN_PREFIX.append(Component.text((String)"An update for PerfoBooster is available! ").color((TextColor)NamedTextColor.GREEN)).append(((TextComponent)Component.text((String)("v" + this.latestVersion)).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)))).append(Component.text((String)(" (Current: v" + this.plugin.getDescription().getVersion() + "). ")).color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Use ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"/perfobooster update").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" for details.").color((TextColor)NamedTextColor.AQUA)));
            }, 2L, TimeUnit.SECONDS);
        }
    }

    public void displayUpdateInfo(CommandSender sender) {
        if (!this.isUpdateCheckerEnabled()) {
            this.sendUpdateCheckerDisabled(sender);
            return;
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add(((TextComponent)Component.text((String)"Current Version: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)("v" + this.plugin.getDescription().getVersion())).color((TextColor)NamedTextColor.WHITE)));
        if (this.latestVersion != null) {
            lines.add(((TextComponent)Component.text((String)"Latest Version: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)("v" + this.latestVersion)).color((TextColor)NamedTextColor.GREEN)));
            lines.add(((TextComponent)Component.text((String)"Status: ").color((TextColor)NamedTextColor.GOLD)).append(((TextComponent)Component.text((String)"Update Available!").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.BOLD)));
            if (this.downloadUrl != null) {
                lines.add(((TextComponent)Component.text((String)"Download: ").color((TextColor)NamedTextColor.AQUA)).append(((TextComponent)((TextComponent)Component.text((String)("https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)).color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/perfobooster/version/" + this.latestVersion)))));
            }
            lines.add(Component.text((String)"Note: Please backup your server before updating.").color(TextColor.color((int)0x252525)));
        } else {
            lines.add(((TextComponent)Component.text((String)"Latest Version: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"N/A - Check manually or wait").color((TextColor)NamedTextColor.YELLOW)));
            lines.add(((TextComponent)Component.text((String)"Status: ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"Up to date!").color((TextColor)NamedTextColor.GREEN)));
        }
        lines.add(Component.text((String)"Settings:").color((TextColor)NamedTextColor.BLUE));
        lines.add(((TextComponent)Component.text((String)"  Ignore Alpha: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.isIgnoreAlpha() ? "Yes" : "No")).color((TextColor)(this.isIgnoreAlpha() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        lines.add(((TextComponent)Component.text((String)"  Ignore Beta: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.isIgnoreBeta() ? "Yes" : "No")).color((TextColor)(this.isIgnoreBeta() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        lines.add(((TextComponent)Component.text((String)"  Admin Alerts: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.isAlertOnAdminJoinEnabled() ? "Enabled" : "Disabled")).color((TextColor)(this.isAlertOnAdminJoinEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        lines.add(((TextComponent)Component.text((String)"  Check Interval: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.plugin.getConfig().getInt("updateChecker.checkIntervalHours", 6) + " hours")).color((TextColor)NamedTextColor.WHITE)));
        lines.add(((TextComponent)Component.text((String)"  Auto-Update: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.isAutoUpdateEnabled() ? "Enabled" : "Disabled")).color((TextColor)(this.isAutoUpdateEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        if (this.isAutoUpdateEnabled()) {
            lines.add(((TextComponent)Component.text((String)"  Auto-Update Interval: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)(this.plugin.getConfig().getInt("updateChecker.autoUpdate.updateCheckInterval", 24) + " hours")).color((TextColor)NamedTextColor.WHITE)));
        }
        this.sendFormattedResponse(sender, "Update Information", lines);
    }

    public void forceUpdateCheck(CommandSender sender) {
        sender.sendMessage(Component.text((String)"Checking for updates...").color((TextColor)NamedTextColor.YELLOW));
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/perfobooster/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "PerfoBooster/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(10000);
                JsonArray versions = JsonParser.parseReader((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonArray();
                String foundVersion = null;
                String foundDownloadUrl = null;
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionNumber = version.get("version_number").getAsString();
                    String versionType = version.has("version_type") ? version.get("version_type").getAsString() : "release";
                    if (!this.shouldCheckVersionType(versionType) || !this.isNewerByDate(version, this.plugin.getDescription().getVersion(), versions)) continue;
                    foundVersion = versionNumber;
                    foundDownloadUrl = version.getAsJsonArray("files").get(0).getAsJsonObject().get("url").getAsString();
                    break;
                }
                if (foundVersion != null) {
                    this.latestVersion = foundVersion;
                    this.downloadUrl = foundDownloadUrl;
                }
                String finalFoundVersion = foundVersion;
                String finalFoundDownloadUrl = foundDownloadUrl;
                this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, tasked -> {
                    if (finalFoundVersion != null) {
                        this.sendUpdateFound(sender, finalFoundVersion, finalFoundDownloadUrl);
                    } else {
                        this.sendNoUpdateFound(sender);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, tasked -> this.sendUpdateCheckFailed(sender, e.getMessage()));
            }
        });
    }

    private void sendFormattedResponse(CommandSender sender, String title, List<Component> lines) {
        String version = this.plugin.getDescription().getVersion();
        Component pluginName = ((TextComponent)Component.text((String)"PerfoBooster").color(TextColor.color((int)61951))).decorate(TextDecoration.BOLD);
        Component versionComponent = ((TextComponent)((TextComponent)Component.text((String)" (").color(TextColor.color((int)0x252525))).append(((TextComponent)Component.text((String)version).color((TextColor)NamedTextColor.WHITE)).decorate(TextDecoration.BOLD))).append(Component.text((String)")").color(TextColor.color((int)0x252525)));
        Component combined = pluginName.append(versionComponent);
        int totalWidth = 31;
        int textWidth = "PerfoBooster".length() + version.length() + 3;
        int padding = (totalWidth - textWidth) / 2;
        Object paddingStr = "";
        for (int i = 0; i < padding; ++i) {
            paddingStr = (String)paddingStr + " ";
        }
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        sender.sendMessage(Component.text((String)paddingStr).append(combined));
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        String titleText = " + " + title + " + ";
        padding = (totalWidth - titleText.length()) / 2;
        paddingStr = "";
        for (int i = 0; i < padding; ++i) {
            paddingStr = (String)paddingStr + " ";
        }
        sender.sendMessage(Component.text((String)((String)paddingStr + titleText)).color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
        for (Component line : lines) {
            sender.sendMessage(line);
        }
        sender.sendMessage(Component.text((String)"-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-").color(TextColor.color((int)0x252525)));
    }

    private void sendUpdateFound(CommandSender sender, String version, String downloadUrl) {
        List<Component> lines = List.of(((TextComponent)((TextComponent)Component.text((String)"Update found! Version ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)version).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" is available.").color((TextColor)NamedTextColor.GREEN)), ((TextComponent)Component.text((String)"Download: ").color((TextColor)NamedTextColor.YELLOW)).append(((TextComponent)((TextComponent)Component.text((String)("https://modrinth.com/plugin/perfobooster/version/" + version)).color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/perfobooster/version/" + version)))));
        this.sendFormattedResponse(sender, "Update Available", lines);
    }

    private void sendNoUpdateFound(CommandSender sender) {
        List<Component> lines = List.of(Component.text((String)"No updates available. You're running the latest version!").color((TextColor)NamedTextColor.GREEN));
        this.sendFormattedResponse(sender, "Update Check", lines);
    }

    private void sendUpdateCheckFailed(CommandSender sender, String errorMessage) {
        List<Component> lines = List.of(Component.text((String)("Failed to check for updates: " + errorMessage)).color((TextColor)NamedTextColor.RED));
        this.sendFormattedResponse(sender, "Update Check Failed", lines);
    }

    private void sendUpdateCheckerDisabled(CommandSender sender) {
        List<Component> lines = List.of(Component.text((String)"The update checker is currently disabled in the config.").color((TextColor)NamedTextColor.RED));
        this.sendFormattedResponse(sender, "Update Information", lines);
    }

    public boolean isUpdateCheckerEnabled() {
        return this.plugin.getConfig().getBoolean("updateChecker.enabled", true);
    }

    private boolean isIgnoreAlpha() {
        return this.plugin.getConfig().getBoolean("updateChecker.ignoreAlpha", true);
    }

    private boolean isIgnoreBeta() {
        return this.plugin.getConfig().getBoolean("updateChecker.ignoreBeta", true);
    }

    private boolean isAlertOnAdminJoinEnabled() {
        return this.plugin.getConfig().getBoolean("updateChecker.alert.onAdminJoin", true);
    }

    private boolean isAutoUpdateEnabled() {
        return this.plugin.getConfig().getBoolean("updateChecker.autoUpdate.enabled", false);
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isUpdateAvailable() {
        return this.latestVersion != null;
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        if (this.autoUpdateTask != null) {
            this.autoUpdateTask.cancel();
            this.autoUpdateTask = null;
        }
    }
}

