/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.block;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class AdjustSpawner
implements Listener {
    private final PerfoBooster plugin;
    private ScheduledTask optimizationTask;
    private boolean adjustSpawnerEnabled;
    private int minSpawnDelay;
    private int maxSpawnDelay;
    private double spawnRateMultiplier;
    private int minLightLevel;
    private int maxLightLevel;
    private boolean requirePlayerInRange;
    private final Set<String> loadedChunks = ConcurrentHashMap.newKeySet();
    private final Map<String, Long> spawnerLastOptimized = new ConcurrentHashMap<String, Long>();

    public AdjustSpawner(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.adjustSpawnerEnabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startOptimizationTask();
        }
    }

    private void loadConfig() {
        this.adjustSpawnerEnabled = this.plugin.getConfig().getBoolean("blockOptimization.adjustSpawner.enabled", true);
        if (!this.adjustSpawnerEnabled) {
            return;
        }
        this.minSpawnDelay = this.plugin.getConfig().getInt("blockOptimization.adjustSpawner.minSpawnDelay", 200);
        this.maxSpawnDelay = this.plugin.getConfig().getInt("blockOptimization.adjustSpawner.maxSpawnDelay", 800);
        this.spawnRateMultiplier = this.plugin.getConfig().getDouble("blockOptimization.adjustSpawner.spawnRateMultiplier", 1.0);
        this.minLightLevel = this.plugin.getConfig().getInt("blockOptimization.adjustSpawner.spawnConditions.minLightLevel", 0);
        this.maxLightLevel = this.plugin.getConfig().getInt("blockOptimization.adjustSpawner.spawnConditions.maxLightLevel", 7);
        this.requirePlayerInRange = this.plugin.getConfig().getBoolean("blockOptimization.adjustSpawner.spawnConditions.requirePlayerInRange", true);
    }

    private void startOptimizationTask() {
        if (!this.adjustSpawnerEnabled) {
            return;
        }
        this.optimizationTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.optimizeSpawners(), 100L, 200L);
    }

    private void optimizeSpawners() {
        if (this.loadedChunks.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (String chunkKey : this.loadedChunks) {
            World world;
            String[] parts;
            if (this.spawnerLastOptimized.containsKey(chunkKey) && currentTime - this.spawnerLastOptimized.get(chunkKey) < 30000L || (parts = chunkKey.split(":")).length != 3 || (world = Bukkit.getWorld((String)parts[0])) == null) continue;
            try {
                int chunkX = Integer.parseInt(parts[1]);
                int chunkZ = Integer.parseInt(parts[2]);
                if (!world.isChunkLoaded(chunkX, chunkZ)) {
                    this.loadedChunks.remove(chunkKey);
                    this.spawnerLastOptimized.remove(chunkKey);
                    continue;
                }
                Location chunkLocation = new Location(world, (double)(chunkX << 4), 64.0, (double)(chunkZ << 4));
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, chunkLocation, () -> {
                    if (world.isChunkLoaded(chunkX, chunkZ)) {
                        Chunk chunk = world.getChunkAt(chunkX, chunkZ);
                        this.optimizeSpawnersInChunk(chunk);
                    }
                });
                this.spawnerLastOptimized.put(chunkKey, currentTime);
            }
            catch (NumberFormatException e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Invalid chunk key format: " + chunkKey)).color(TextColor.color((int)0xFF0000))));
                this.loadedChunks.remove(chunkKey);
            }
        }
    }

    private void optimizeSpawnersInChunk(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = chunk.getWorld().getMinHeight(); y < chunk.getWorld().getMaxHeight(); ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    if (block.getType() != Material.SPAWNER) continue;
                    this.optimizeSpawner(block);
                }
            }
        }
    }

    private void optimizeSpawner(Block spawnerBlock) {
        if (!(spawnerBlock.getState() instanceof CreatureSpawner)) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)spawnerBlock.getState();
        Location spawnerLocation = spawnerBlock.getLocation();
        if (this.requirePlayerInRange && !this.isPlayerInRange(spawnerLocation)) {
            return;
        }
        byte lightLevel = spawnerBlock.getLightLevel();
        if (lightLevel < this.minLightLevel || lightLevel > this.maxLightLevel) {
            return;
        }
        this.adjustSpawnerSettings(spawner);
    }

    private boolean isPlayerInRange(Location spawnerLocation) {
        List players = spawnerLocation.getWorld().getPlayers();
        for (Player player : players) {
            if (!(player.getLocation().distance(spawnerLocation) <= 16.0)) continue;
            return true;
        }
        return false;
    }

    private void adjustSpawnerSettings(CreatureSpawner spawner) {
        double currentTPS = this.plugin.getTpsMonitor().getGlobalTps();
        this.adjustBasedOnTPS(spawner, currentTPS);
        spawner.update();
    }

    private void adjustBasedOnTPS(CreatureSpawner spawner, double tps) {
        int baseMinDelay = this.minSpawnDelay;
        int baseMaxDelay = this.maxSpawnDelay;
        if (tps < 15.0) {
            baseMinDelay = (int)((double)this.minSpawnDelay * 1.5);
            baseMaxDelay = (int)((double)this.maxSpawnDelay * 1.5);
        } else if (tps < 18.0) {
            baseMinDelay = (int)((double)this.minSpawnDelay * 1.2);
            baseMaxDelay = (int)((double)this.maxSpawnDelay * 1.2);
        } else if (tps >= 19.0) {
            baseMinDelay = (int)((double)this.minSpawnDelay / this.spawnRateMultiplier);
            baseMaxDelay = (int)((double)this.maxSpawnDelay / this.spawnRateMultiplier);
        }
        spawner.setMinSpawnDelay(Math.max(baseMinDelay, 20));
        spawner.setMaxSpawnDelay(Math.max(baseMaxDelay, baseMinDelay + 20));
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.adjustSpawnerEnabled) {
            return;
        }
        String chunkKey = event.getChunk().getWorld().getName() + ":" + event.getChunk().getX() + ":" + event.getChunk().getZ();
        if (this.chunkContainsSpawners(event.getChunk())) {
            this.loadedChunks.add(chunkKey);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!this.adjustSpawnerEnabled) {
            return;
        }
        String chunkKey = event.getChunk().getWorld().getName() + ":" + event.getChunk().getX() + ":" + event.getChunk().getZ();
        this.loadedChunks.remove(chunkKey);
        this.spawnerLastOptimized.remove(chunkKey);
    }

    private boolean chunkContainsSpawners(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = chunk.getWorld().getMinHeight(); y < chunk.getWorld().getMaxHeight(); ++y) {
                    if (chunk.getBlock(x, y, z).getType() != Material.SPAWNER) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void shutdown() {
        if (this.optimizationTask != null && !this.optimizationTask.isCancelled()) {
            this.optimizationTask.cancel();
        }
        this.loadedChunks.clear();
        this.spawnerLastOptimized.clear();
    }

    public boolean isEnabled() {
        return this.adjustSpawnerEnabled;
    }

    public int getTrackedChunksCount() {
        return this.loadedChunks.size();
    }

    public Set<String> getLoadedChunks() {
        return Set.copyOf(this.loadedChunks);
    }
}

