/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.block;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class HopperOptimizer
implements Listener {
    private final PerfoBooster plugin;
    private final boolean enabled;
    private final boolean smartThrottling;
    private final boolean chunkLimitEnabled;
    private final boolean emptyHopperOptimization;
    private final int maxHoppersPerChunk;
    private final int checkIntervalTicks;
    private final int emptyHopperCheckDelay;
    private final long inactiveThresholdMs;
    private final boolean debugMode;
    private final Set<Hopper> trackedHoppers = ConcurrentHashMap.newKeySet();
    private final Map<String, AtomicInteger> chunkHopperCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<Hopper, Long> hopperLastActivity = new ConcurrentHashMap<Hopper, Long>();
    private final Map<Hopper, Long> hopperLastTransfer = new ConcurrentHashMap<Hopper, Long>();
    private final Map<Hopper, Integer> hopperTransferCount = new ConcurrentHashMap<Hopper, Integer>();
    private ScheduledTask optimizationTask;
    private ScheduledTask cleanupTask;
    private ScheduledTask resetTask;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);

    public HopperOptimizer(PerfoBooster plugin) {
        this.plugin = plugin;
        this.enabled = plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.enabled", false);
        this.smartThrottling = plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.smartThrottling.enabled", true);
        this.chunkLimitEnabled = plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.chunkLimiting.enabled", false);
        this.emptyHopperOptimization = plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.emptyHopperOptimization", true);
        this.maxHoppersPerChunk = plugin.getConfig().getInt("blockOptimization.hopperTweaks.chunkLimiting.maxHoppersPerChunk", 16);
        this.checkIntervalTicks = plugin.getConfig().getInt("blockOptimization.hopperTweaks.checkIntervalTicks", 40);
        this.emptyHopperCheckDelay = plugin.getConfig().getInt("blockOptimization.hopperTweaks.emptyHopperCheckDelay", 100);
        this.inactiveThresholdMs = plugin.getConfig().getLong("blockOptimization.hopperTweaks.inactiveThresholdMs", 30000L);
        this.debugMode = plugin.getConfig().getBoolean("blockOptimization.hopperTweaks.debug", false);
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startOptimizationTasks();
            if (this.debugMode) {
                plugin.getServer().getConsoleSender().sendMessage(plugin.getPrefix().append(Component.text((String)("Hopper optimization enabled with smart throttling: " + this.smartThrottling + ", chunk limiting: " + this.chunkLimitEnabled)).color(TextColor.color((int)0xFFFF00))));
            }
        }
    }

    private void startOptimizationTasks() {
        if (!this.enabled) {
            return;
        }
        this.optimizationTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.optimizeHoppers(), 1L, (long)this.checkIntervalTicks, TimeUnit.SECONDS);
        this.cleanupTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.cleanupInactiveHoppers(), 100L, 200L, TimeUnit.MILLISECONDS);
        this.resetTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.resetTransferCounters(), 1L, 1L, TimeUnit.SECONDS);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Hopper hopper;
        InventoryHolder holder;
        if (!this.enabled || this.isShuttingDown.get()) {
            return;
        }
        if (event.getSource().getType() == InventoryType.HOPPER && (holder = event.getSource().getHolder()) instanceof Hopper) {
            hopper = (Hopper)holder;
            if (this.shouldBlockTransfer(hopper, event)) {
                event.setCancelled(true);
                return;
            }
            this.trackHopperActivity(hopper);
        }
        if (event.getDestination().getType() == InventoryType.HOPPER && (holder = event.getDestination().getHolder()) instanceof Hopper) {
            hopper = (Hopper)holder;
            this.trackHopperActivity(hopper);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        if (event.getBlock().getType() == Material.HOPPER) {
            Block block = event.getBlock();
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                BlockState state = block.getState();
                if (state instanceof Hopper) {
                    Hopper hopper = (Hopper)state;
                    this.trackHopper(hopper);
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        BlockState state;
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        if (event.getBlock().getType() == Material.HOPPER && (state = event.getBlock().getState()) instanceof Hopper) {
            Hopper hopper = (Hopper)state;
            this.removeHopper(hopper);
        }
    }

    private boolean shouldBlockTransfer(Hopper hopper, InventoryMoveItemEvent event) {
        block7: {
            String chunkKey;
            AtomicInteger count;
            if (this.chunkLimitEnabled && (count = this.chunkHopperCount.get(chunkKey = this.getChunkKey(hopper))) != null && count.get() >= this.maxHoppersPerChunk && !this.trackedHoppers.contains(hopper)) {
                if (this.debugMode) {
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Blocked new hopper in chunk " + chunkKey + " (limit: " + this.maxHoppersPerChunk + ")")).color(TextColor.color((int)0xFFFF00))));
                }
                return true;
            }
            if (this.smartThrottling) {
                long currentTime = System.currentTimeMillis();
                Long lastTransfer = this.hopperLastTransfer.get(hopper);
                try {
                    boolean isEmpty = hopper.getInventory().isEmpty();
                    if (isEmpty && this.emptyHopperOptimization && lastTransfer != null && currentTime - lastTransfer < (long)this.emptyHopperCheckDelay) {
                        return true;
                    }
                    Long lastActivity = this.hopperLastActivity.get(hopper);
                    if (lastActivity != null && currentTime - lastActivity > this.inactiveThresholdMs && lastTransfer != null && currentTime - lastTransfer < (long)(this.emptyHopperCheckDelay * 2)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!this.debugMode) break block7;
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Error checking hopper state: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
                }
            }
        }
        return false;
    }

    private void trackHopperActivity(Hopper hopper) {
        if (hopper == null || !hopper.isPlaced()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.hopperLastActivity.put(hopper, currentTime);
        this.hopperLastTransfer.put(hopper, currentTime);
        Integer count = this.hopperTransferCount.get(hopper);
        this.hopperTransferCount.put(hopper, count == null ? 1 : count + 1);
    }

    private void trackHopper(Hopper hopper) {
        if (hopper == null || !hopper.isPlaced()) {
            return;
        }
        this.trackedHoppers.add(hopper);
        this.hopperLastActivity.put(hopper, System.currentTimeMillis());
        if (this.chunkLimitEnabled) {
            String chunkKey = this.getChunkKey(hopper);
            this.chunkHopperCount.computeIfAbsent(chunkKey, k -> new AtomicInteger(0)).incrementAndGet();
        }
        if (this.debugMode) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Tracking hopper at " + String.valueOf(hopper.getLocation()))).color(TextColor.color((int)0xFFFF00))));
        }
    }

    private void removeHopper(Hopper hopper) {
        String chunkKey;
        AtomicInteger count;
        this.trackedHoppers.remove(hopper);
        this.hopperLastActivity.remove(hopper);
        this.hopperLastTransfer.remove(hopper);
        this.hopperTransferCount.remove(hopper);
        if (this.chunkLimitEnabled && (count = this.chunkHopperCount.get(chunkKey = this.getChunkKey(hopper))) != null) {
            count.decrementAndGet();
            if (count.get() <= 0) {
                this.chunkHopperCount.remove(chunkKey);
            }
        }
    }

    private void optimizeHoppers() {
        if (!this.enabled || this.isShuttingDown.get()) {
            return;
        }
        this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
            Set<Hopper> hoppersToProcess = Set.copyOf(this.trackedHoppers);
            if (this.debugMode && !hoppersToProcess.isEmpty()) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Optimizing " + hoppersToProcess.size() + " hoppers")).color(TextColor.color((int)0xFFFF00))));
            }
            for (Hopper hopper : hoppersToProcess) {
                this.optimizeHopper(hopper);
            }
        }, 1L, TimeUnit.MILLISECONDS);
    }

    private void optimizeHopper(Hopper hopper) {
        if (hopper == null) {
            return;
        }
        try {
            if (!hopper.isPlaced() || !hopper.getChunk().isLoaded()) {
                this.removeHopper(hopper);
                return;
            }
            int cooldown = this.calculateOptimalCooldown(hopper);
            hopper.setTransferCooldown(cooldown);
            if (this.debugMode) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Set hopper cooldown to " + cooldown + " at " + hopper.getLocation().toString())).color(TextColor.color((int)0xFFFF00))));
            }
        }
        catch (Exception e) {
            if (this.debugMode) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Error optimizing hopper: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
            }
            this.removeHopper(hopper);
        }
    }

    private int calculateOptimalCooldown(Hopper hopper) {
        int baseCooldown = 8;
        if (!this.smartThrottling) {
            return baseCooldown;
        }
        try {
            boolean isEmpty = hopper.getInventory().isEmpty();
            if (isEmpty && this.emptyHopperOptimization) {
                return Math.max(baseCooldown * 3, 20);
            }
            Long lastActivity = this.hopperLastActivity.get(hopper);
            if (lastActivity != null) {
                long timeSinceActivity = System.currentTimeMillis() - lastActivity;
                if (timeSinceActivity > this.inactiveThresholdMs * 2L) {
                    return Math.min(baseCooldown * 4, 50);
                }
                if (timeSinceActivity > this.inactiveThresholdMs) {
                    return Math.min(baseCooldown * 2, 25);
                }
            }
            return baseCooldown;
        }
        catch (Exception e) {
            if (this.debugMode) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Error calculating cooldown for hopper: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
            }
            return baseCooldown;
        }
    }

    private void resetTransferCounters() {
        this.hopperTransferCount.clear();
    }

    private void cleanupInactiveHoppers() {
        if (!this.enabled || this.isShuttingDown.get()) {
            return;
        }
        this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
            long currentTime = System.currentTimeMillis();
            AtomicInteger removedCount = new AtomicInteger(0);
            this.trackedHoppers.removeIf(hopper -> {
                try {
                    if (hopper == null || !hopper.isPlaced() || !hopper.getChunk().isLoaded()) {
                        this.removeHopper((Hopper)hopper);
                        removedCount.incrementAndGet();
                        return true;
                    }
                    Long lastActivity = this.hopperLastActivity.get(hopper);
                    if (lastActivity != null && currentTime - lastActivity > 300000L) {
                        this.removeHopper((Hopper)hopper);
                        removedCount.incrementAndGet();
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    this.removeHopper((Hopper)hopper);
                    removedCount.incrementAndGet();
                    return true;
                }
            });
            if (this.chunkLimitEnabled) {
                this.chunkHopperCount.entrySet().removeIf(entry -> {
                    try {
                        String[] parts = ((String)entry.getKey()).split(":");
                        if (parts.length != 3) {
                            return true;
                        }
                        String worldName = parts[0];
                        int chunkX = Integer.parseInt(parts[1]);
                        int chunkZ = Integer.parseInt(parts[2]);
                        return this.plugin.getServer().getWorld(worldName) == null || !this.plugin.getServer().getWorld(worldName).isChunkLoaded(chunkX, chunkZ);
                    }
                    catch (Exception e) {
                        return true;
                    }
                });
            }
            if (this.debugMode && removedCount.get() > 0) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Cleaned up " + removedCount.get() + " inactive hoppers")).color(TextColor.color((int)0xFFFF00))));
            }
        }, 1L, TimeUnit.MILLISECONDS);
    }

    private String getChunkKey(Hopper hopper) {
        Chunk chunk = hopper.getChunk();
        return chunk.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        this.isShuttingDown.set(true);
        if (this.optimizationTask != null && !this.optimizationTask.isCancelled()) {
            this.optimizationTask.cancel();
        }
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel();
        }
        if (this.resetTask != null && !this.resetTask.isCancelled()) {
            this.resetTask.cancel();
        }
        this.trackedHoppers.clear();
        this.hopperLastActivity.clear();
        this.hopperLastTransfer.clear();
        this.hopperTransferCount.clear();
        this.chunkHopperCount.clear();
        if (this.debugMode) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Hopper optimization shut down").color(TextColor.color((int)65280))));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTrackedHopperCount() {
        return this.trackedHoppers.size();
    }

    public Map<String, AtomicInteger> getChunkHopperCounts() {
        return Map.copyOf(this.chunkHopperCount);
    }
}

