/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.chunk;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import me.bloodred.perfobooster.PerfoBooster;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InactiveChunkUnloader {
    private final PerfoBooster plugin;
    private boolean unloadInactiveEnabled;
    private double unloadDistanceFactor;
    private int checkInterval;
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public InactiveChunkUnloader(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.startChunkUnloadTask();
    }

    private void loadConfig() {
        this.unloadInactiveEnabled = this.plugin.getConfig().getBoolean("chunkManagement.unloadInactiveChunks.enabled", true);
        this.unloadDistanceFactor = this.plugin.getConfig().getDouble("chunkManagement.unloadInactiveChunks.unloadDistanceFactor", 1.5);
        this.checkInterval = this.plugin.getConfig().getInt("chunkManagement.unloadInactiveChunks.checkInterval", 30);
    }

    private void startChunkUnloadTask() {
        if (!this.unloadInactiveEnabled) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            Location spawnLocation = world.getSpawnLocation();
            if (spawnLocation == null) {
                spawnLocation = new Location(world, 0.0, 64.0, 0.0);
            }
            this.scheduledTasks.add(this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, spawnLocation, task -> this.scanAndUnloadChunks(world), 100L, (long)this.checkInterval * 20L));
        }
    }

    private void scanAndUnloadChunks(World world) {
        int simulationDistance = world.getSimulationDistance();
        int unloadDistance = (int)Math.ceil((double)simulationDistance * this.unloadDistanceFactor);
        if (unloadDistance <= simulationDistance) {
            unloadDistance = simulationDistance + 1;
        }
        ArrayList<Chunk> chunksToUnload = new ArrayList<Chunk>();
        for (Chunk chunk : world.getLoadedChunks()) {
            if (!chunk.isLoaded()) continue;
            boolean shouldUnload = true;
            if (chunk.isSlimeChunk()) {
                shouldUnload = false;
            } else {
                for (Player player : world.getPlayers()) {
                    int distanceZ;
                    Location playerLoc;
                    if (!player.isOnline() || (playerLoc = player.getLocation()).getWorld() == null || !playerLoc.getWorld().equals((Object)world)) continue;
                    int playerChunkX = playerLoc.getBlockX() >> 4;
                    int playerChunkZ = playerLoc.getBlockZ() >> 4;
                    int distanceX = Math.abs(playerChunkX - chunk.getX());
                    if (Math.max(distanceX, distanceZ = Math.abs(playerChunkZ - chunk.getZ())) > unloadDistance) continue;
                    shouldUnload = false;
                    break;
                }
            }
            if (!shouldUnload) continue;
            chunksToUnload.add(chunk);
        }
        for (Chunk chunk : chunksToUnload) {
            Location chunkLocation = new Location(world, (double)(chunk.getX() << 4), 64.0, (double)(chunk.getZ() << 4));
            this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, chunkLocation, () -> {
                if (chunk.isLoaded()) {
                    chunk.unload(true);
                }
            });
        }
    }

    public void shutdown() {
        for (ScheduledTask task : this.scheduledTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.scheduledTasks.clear();
    }

    public boolean isEnabled() {
        return this.unloadInactiveEnabled;
    }
}

