/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.entity;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.plugin.Plugin;

public class FarmRateLimiter
implements Listener {
    private final PerfoBooster plugin;
    private final Map<String, Integer> chunkBreedingCount = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> spawnerSpawnCount = new ConcurrentHashMap<String, Integer>();
    private int breedLimit;
    private int spawnerLimit;
    private boolean farmLimitingEnabled;
    private ScheduledTask cleanupTask;

    public FarmRateLimiter(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.farmLimitingEnabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startCleanupTask();
        }
    }

    private void loadConfig() {
        this.farmLimitingEnabled = this.plugin.getConfig().getBoolean("entityManagement.farmRateLimiting.enabled", true);
        if (!this.farmLimitingEnabled) {
            return;
        }
        this.breedLimit = this.plugin.getConfig().getInt("entityManagement.farmRateLimiting.breedLimit", 5);
        this.spawnerLimit = this.plugin.getConfig().getInt("entityManagement.farmRateLimiting.spawnerLimit", 8);
    }

    private void startCleanupTask() {
        if (!this.farmLimitingEnabled) {
            return;
        }
        this.cleanupTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            this.chunkBreedingCount.clear();
            this.spawnerSpawnCount.clear();
        }, 1200L, 1200L, TimeUnit.SECONDS);
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        if (!this.farmLimitingEnabled) {
            return;
        }
        Chunk chunk = event.getEntity().getLocation().getChunk();
        String chunkKey = chunk.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
        int currentCount = this.chunkBreedingCount.getOrDefault(chunkKey, 0);
        if (currentCount >= this.breedLimit) {
            event.setCancelled(true);
            return;
        }
        this.chunkBreedingCount.put(chunkKey, currentCount + 1);
    }

    @EventHandler
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        if (!this.farmLimitingEnabled) {
            return;
        }
        Chunk chunk = event.getSpawner().getChunk();
        String chunkKey = chunk.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
        int currentCount = this.spawnerSpawnCount.getOrDefault(chunkKey, 0);
        if (currentCount >= this.spawnerLimit) {
            event.setCancelled(true);
            return;
        }
        this.spawnerSpawnCount.put(chunkKey, currentCount + 1);
    }

    public void shutdown() {
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel();
        }
        this.chunkBreedingCount.clear();
        this.spawnerSpawnCount.clear();
    }

    public boolean isEnabled() {
        return this.farmLimitingEnabled;
    }
}

