/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.util;

import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TPSMonitor {
    private final JavaPlugin plugin;
    private final long startTime;
    private static final long STABILIZATION_PERIOD = 45000L;
    private final Map<String, Double> regionTps = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> regionMspt = new ConcurrentHashMap<String, Double>();
    private final Map<String, RegionTickData> regionTickData = new ConcurrentHashMap<String, RegionTickData>();
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public TPSMonitor(JavaPlugin plugin) {
        this.plugin = plugin;
        this.startTime = System.currentTimeMillis();
        this.setupGlobalMonitoring();
        this.setupWorldRegionMonitoring();
    }

    private boolean isStabilizationPeriod() {
        return System.currentTimeMillis() - this.startTime < 45000L;
    }

    private void setupGlobalMonitoring() {
        String globalKey = "global";
        this.regionTps.put(globalKey, 20.0);
        this.regionMspt.put(globalKey, 50.0);
        RegionTickData data = new RegionTickData();
        data.measurementStartTime = data.lastTickTime = System.currentTimeMillis();
        this.regionTickData.put(globalKey, data);
        ScheduledTask globalTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.updateRegionTps(globalKey), 1L, 1L, TimeUnit.SECONDS);
        this.scheduledTasks.add(globalTask);
    }

    private void setupWorldRegionMonitoring() {
        for (World world : this.plugin.getServer().getWorlds()) {
            this.setupWorldMonitoring(world);
        }
        ScheduledTask worldCheckTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            for (World world : this.plugin.getServer().getWorlds()) {
                String worldKey = "world:" + world.getName();
                if (this.regionTickData.containsKey(worldKey)) continue;
                this.setupWorldMonitoring(world);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        this.scheduledTasks.add(worldCheckTask);
    }

    private void setupWorldMonitoring(World world) {
        String worldKey = "world:" + world.getName();
        this.regionTps.put(worldKey, 20.0);
        this.regionMspt.put(worldKey, 50.0);
        RegionTickData data = new RegionTickData();
        data.measurementStartTime = data.lastTickTime = System.currentTimeMillis();
        this.regionTickData.put(worldKey, data);
        Location spawnLoc = world.getSpawnLocation();
        RegionScheduler regionScheduler = this.plugin.getServer().getRegionScheduler();
        ScheduledTask regionTask = regionScheduler.runAtFixedRate((Plugin)this.plugin, spawnLoc, task -> this.updateRegionTps(worldKey), 1L, 1L);
        this.scheduledTasks.add(regionTask);
    }

    private void updateRegionTps(String regionKey) {
        RegionTickData data = this.regionTickData.get(regionKey);
        if (data == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (data.tickStartTime == 0L) {
            data.tickStartTime = now;
        }
        long tickDuration = now - data.tickStartTime;
        data.totalTickTime += tickDuration;
        long elapsed = now - data.lastTickTime;
        data.lastTickTime = now;
        data.tickStartTime = now;
        ++data.tickCount;
        long totalElapsed = now - data.measurementStartTime;
        if (totalElapsed >= 1000L) {
            double weight;
            double mspt;
            double tps = (double)data.tickCount / ((double)totalElapsed / 1000.0);
            double d = mspt = data.tickCount > 0 ? (double)data.totalTickTime / (double)data.tickCount : 50.0;
            if (data.rollingTicksPerSecond > 0.0) {
                weight = 0.8;
                data.rollingTicksPerSecond = data.rollingTicksPerSecond * weight + tps * (1.0 - weight);
            } else {
                data.rollingTicksPerSecond = tps;
            }
            if (data.rollingMspt > 0.0) {
                weight = 0.8;
                data.rollingMspt = data.rollingMspt * weight + mspt * (1.0 - weight);
            } else {
                data.rollingMspt = mspt;
            }
            if (data.rollingTicksPerSecond > 20.0) {
                data.rollingTicksPerSecond = 20.0;
            }
            if (data.rollingMspt < 0.0) {
                data.rollingMspt = 0.0;
            }
            double roundedTps = (double)Math.round(data.rollingTicksPerSecond * 10.0) / 10.0;
            double roundedMspt = (double)Math.round(data.rollingMspt * 100.0) / 100.0;
            this.regionTps.put(regionKey, roundedTps);
            this.regionMspt.put(regionKey, roundedMspt);
            data.tickCount = 0;
            data.totalTickTime = 0L;
            data.measurementStartTime = now;
        }
    }

    public double getWorldTps(World world) {
        if (this.isStabilizationPeriod()) {
            return 20.0;
        }
        String worldKey = "world:" + world.getName();
        return this.regionTps.getOrDefault(worldKey, 20.0);
    }

    public double getWorldMspt(World world) {
        if (this.isStabilizationPeriod()) {
            return 50.0;
        }
        String worldKey = "world:" + world.getName();
        return this.regionMspt.getOrDefault(worldKey, 50.0);
    }

    public double getGlobalTps() {
        if (this.isStabilizationPeriod()) {
            return 20.0;
        }
        return this.regionTps.getOrDefault("global", 20.0);
    }

    public double getGlobalMspt() {
        if (this.isStabilizationPeriod()) {
            return 50.0;
        }
        return this.regionMspt.getOrDefault("global", 50.0);
    }

    public void shutdown() {
        for (ScheduledTask task : this.scheduledTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.scheduledTasks.clear();
        this.regionTps.clear();
        this.regionMspt.clear();
        this.regionTickData.clear();
    }

    private static class RegionTickData {
        long lastTickTime;
        long tickStartTime;
        int tickCount;
        double rollingTicksPerSecond;
        double rollingMspt;
        long measurementStartTime;
        long totalTickTime;

        private RegionTickData() {
        }
    }
}

