/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.block;

import java.util.ArrayList;
import java.util.List;
import me.bloodred.perfobooster.PerfoBooster;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InstantLeafDecay
implements Listener {
    private final PerfoBooster plugin;
    private final ArrayList<BlockFace> neighbours = new ArrayList<BlockFace>(List.of(BlockFace.values()));
    private boolean enabled;
    private int maxDistance;
    private int maxGridDistance;
    private boolean breakOnLogBreak;
    private boolean breakOnNaturalDecay;
    private boolean respectPersistentLeaves;
    private boolean dropItems;

    public InstantLeafDecay(PerfoBooster plugin) {
        this.plugin = plugin;
        this.neighbours.remove(BlockFace.SELF);
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.enabled", true);
        if (!this.enabled) {
            return;
        }
        this.maxDistance = this.plugin.getConfig().getInt("blockOptimization.instantLeafDecay.maxDistance", 7);
        this.maxGridDistance = this.plugin.getConfig().getInt("blockOptimization.instantLeafDecay.maxGridDistance", 35);
        this.breakOnLogBreak = this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.breakOnLogBreak", true);
        this.breakOnNaturalDecay = this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.breakOnNaturalDecay", true);
        this.respectPersistentLeaves = this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.respectPersistentLeaves", true);
        this.dropItems = this.plugin.getConfig().getBoolean("blockOptimization.instantLeafDecay.dropItems", true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(@NotNull BlockBreakEvent event) {
        if (!this.enabled) {
            return;
        }
        Block block = event.getBlock();
        if (Tag.LEAVES.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, this.isValidLeaf(block), block);
        }
        if (this.breakOnLogBreak && Tag.LOGS.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, false, block);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeavesDecay(LeavesDecayEvent event) {
        if (!this.enabled || !this.breakOnNaturalDecay) {
            return;
        }
        this.breakLeaf(event.getBlock(), this.isValidLeaf(event.getBlock(), event.getBlock()), event.getBlock());
    }

    private void breakLeaf(Block block, boolean breakFirstBlock, Block originalBlock) {
        if (breakFirstBlock) {
            if (this.dropItems) {
                block.breakNaturally();
            } else {
                block.setType(Material.AIR);
            }
        }
        this.neighbours.forEach(neighbour -> {
            Block neighbourBlock = block.getRelative(neighbour);
            if (!this.isValidLeaf(neighbourBlock, originalBlock)) {
                return;
            }
            this.breakLeaf(neighbourBlock, true, originalBlock);
        });
    }

    private boolean isValidLeaf(Block block, Block originalBlock) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Leaves)) {
            return false;
        }
        Leaves leafBlock = (Leaves)blockData;
        if (leafBlock.getDistance() < this.maxDistance) {
            return false;
        }
        if (this.respectPersistentLeaves && leafBlock.isPersistent()) {
            return false;
        }
        return this.getGridDistance(block, originalBlock) <= this.maxGridDistance;
    }

    private boolean isValidLeaf(Block block) {
        return this.isValidLeaf(block, block);
    }

    private int getGridDistance(Block b1, Block b2) {
        return Math.abs(b1.getX() - b2.getX()) + Math.abs(b1.getY() - b2.getY()) + Math.abs(b1.getZ() - b2.getZ());
    }

    public void shutdown() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

