/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.chunk;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadController
implements Listener {
    private final PerfoBooster plugin;
    private boolean enabled;
    private final Set<String> allowedPlugins = new HashSet<String>();

    public ChunkLoadController(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("chunkManagement.chunkLoadControl.enabled", false);
        List configuredAllowedPlugins = this.plugin.getConfig().getStringList("chunkManagement.chunkLoadControl.allowedPlugins");
        this.allowedPlugins.addAll(configuredAllowedPlugins);
        this.allowedPlugins.add("PerfoBooster");
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        StackTraceElement[] stackTrace;
        if (!this.enabled || !event.isNewChunk() || event.isAsynchronous()) {
            return;
        }
        String pluginName = "Unknown";
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                if (p.getClass().getPackage() == null || !className.startsWith(p.getClass().getPackage().getName())) continue;
                pluginName = p.getName();
                break;
            }
            if (!pluginName.equals("Unknown")) break;
        }
        if (!this.allowedPlugins.contains(pluginName)) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Prevented chunk load by plugin: " + pluginName + " at " + event.getChunk().getX() + "," + event.getChunk().getZ() + " in world " + event.getWorld().getName() + " (Consider adding to chunkManagement.chunkLoadControl.allowedPlugins in config.yml)")).color(TextColor.color((int)65535))));
        }
    }

    public void shutdown() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

