/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.memory;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.plugin.Plugin;

public class GarbageCollectionManager {
    private final PerfoBooster plugin;
    private ScheduledTask task;
    private boolean enabled;
    private double gcThresholdPercentage;
    private int checkIntervalSeconds;
    private boolean silentGC;
    private boolean hasWarnedAboutGCFlags = false;

    public GarbageCollectionManager(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.enabled) {
            this.checkGCConfiguration();
            this.startMemoryTask();
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("memoryPerformanceTweaks.garbageCollection.enabled", true);
        this.gcThresholdPercentage = this.plugin.getConfig().getDouble("memoryPerformanceTweaks.garbageCollection.thresholdPercentage", 82.5);
        this.checkIntervalSeconds = this.plugin.getConfig().getInt("memoryPerformanceTweaks.garbageCollection.checkIntervalSeconds", 10);
        this.silentGC = this.plugin.getConfig().getBoolean("memoryPerformanceTweaks.garbageCollection.silent", false);
    }

    private void checkGCConfiguration() {
        try {
            List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            boolean hasDisableExplicitGC = false;
            boolean hasUseG1GC = false;
            boolean hasUseZGC = false;
            boolean hasUseShenandoahGC = false;
            for (String arg : jvmArgs) {
                if (arg.contains("-XX:+DisableExplicitGC")) {
                    hasDisableExplicitGC = true;
                    continue;
                }
                if (arg.contains("-XX:+UseG1GC")) {
                    hasUseG1GC = true;
                    continue;
                }
                if (arg.contains("-XX:+UseZGC") || arg.contains("-XX:+UnlockExperimentalVMOptions") && jvmArgs.stream().anyMatch(a -> a.contains("-XX:+UseZGC"))) {
                    hasUseZGC = true;
                    continue;
                }
                if (!arg.contains("-XX:+UseShenandoahGC")) continue;
                hasUseShenandoahGC = true;
            }
            if (hasDisableExplicitGC) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"-XX:+DisableExplicitGC JVM flag detected! ").color(TextColor.color((int)0xFFFF00))).append(Component.text((String)"PerfoBooster's garbage collection feature will not work. ").color(TextColor.color((int)0xFFFFFF))).append(Component.text((String)"Consider removing this flag or disabling GC in PerfoBooster config.").color(TextColor.color((int)0xFFFFFF))));
            }
            if (hasUseG1GC || hasUseZGC || hasUseShenandoahGC) {
                String gcType = hasUseZGC ? "ZGC" : (hasUseShenandoahGC ? "Shenandoah" : "G1");
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Detected " + gcType + " garbage collector. ")).color(TextColor.color((int)0xFFFFFF))).append(Component.text((String)"Modern GCs handle memory efficiently - you may want to disable PerfoBooster's GC feature.").color(TextColor.color((int)0xFFFFFF))));
            }
        }
        catch (Exception e) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Could not check JVM garbage collection configuration: " + e.getMessage())).color(TextColor.color((int)0xFFFF00))));
        }
    }

    private void startMemoryTask() {
        if (!this.enabled) {
            return;
        }
        this.task = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.checkMemoryUsage(), (long)this.checkIntervalSeconds, (long)this.checkIntervalSeconds, TimeUnit.SECONDS);
    }

    private void checkMemoryUsage() {
        long freeMemory;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - (freeMemory = runtime.freeMemory());
        double usagePercentage = (double)usedMemory / (double)maxMemory * 100.0;
        if (usagePercentage >= this.gcThresholdPercentage) {
            if (!this.silentGC) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Memory usage at " + String.format("%.2f", usagePercentage) + "% (threshold: " + this.gcThresholdPercentage + "%). Running garbage collection...")).color(TextColor.color((int)0xFF0000))));
            }
            long memoryBeforeGC = usedMemory;
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            totalMemory = runtime.totalMemory();
            freeMemory = runtime.freeMemory();
            usedMemory = totalMemory - freeMemory;
            double newUsagePercentage = (double)usedMemory / (double)maxMemory * 100.0;
            if (!this.silentGC) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Garbage collection complete. Memory usage now at " + String.format("%.2f", newUsagePercentage) + "%")).color(TextColor.color((int)65280))));
            }
            if ((double)Math.abs(memoryBeforeGC - usedMemory) < (double)maxMemory * 0.005 && !this.hasWarnedAboutGCFlags) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Garbage collection appears ineffective. ").color(TextColor.color((int)0xFFFF00))).append(Component.text((String)"This may be due to JVM flags like -XX:+DisableExplicitGC. ").color(TextColor.color((int)0xFFFFFF))).append(Component.text((String)"Check your server startup flags.").color(TextColor.color((int)0xFFFFFF))));
                this.hasWarnedAboutGCFlags = true;
            }
        }
    }

    public void shutdown() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
            this.task = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

