/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.network;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class IdleSimulationDistance
implements Listener {
    private final PerfoBooster plugin;
    private ScheduledTask task;
    private boolean idleSimulationDistanceEnabled;
    private long idleThresholdTicks;
    private int idleSimulationDistance;
    private int defaultSimulationDistance;
    private boolean debugMode;
    private final Map<UUID, PlayerActivityData> playerActivityMap = new ConcurrentHashMap<UUID, PlayerActivityData>();

    public IdleSimulationDistance(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.idleSimulationDistanceEnabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startIdleCheckTask();
        }
    }

    private void loadConfig() {
        this.idleSimulationDistanceEnabled = this.plugin.getConfig().getBoolean("playerNetworkOptimization.idleSimulationDistance.enabled", true);
        if (!this.idleSimulationDistanceEnabled) {
            return;
        }
        int idleThresholdSeconds = this.plugin.getConfig().getInt("playerNetworkOptimization.idleSimulationDistance.idleThresholdSeconds", 30);
        this.idleThresholdTicks = (long)idleThresholdSeconds * 20L;
        this.idleSimulationDistance = this.plugin.getConfig().getInt("playerNetworkOptimization.idleSimulationDistance.idleSimulationDistance", 1);
        this.defaultSimulationDistance = this.plugin.getConfig().getInt("playerNetworkOptimization.idleSimulationDistance.defaultSimulationDistance", 10);
        this.debugMode = this.plugin.getConfig().getBoolean("playerNetworkOptimization.idleSimulationDistance.debugMode", false);
        if (this.idleThresholdTicks < 20L) {
            this.idleThresholdTicks = 20L;
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Idle threshold too low, set to minimum 1 second").color(TextColor.color((int)0xFFFF00))));
        }
        if (this.idleSimulationDistance < 1) {
            this.idleSimulationDistance = 1;
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Idle simulation distance too low, set to minimum 1").color(TextColor.color((int)0xFFFF00))));
        }
        if (this.defaultSimulationDistance < 1) {
            this.defaultSimulationDistance = 10;
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Default simulation distance invalid, set to 10").color(TextColor.color((int)0xFFFF00))));
        }
    }

    private void startIdleCheckTask() {
        if (!this.idleSimulationDistanceEnabled) {
            return;
        }
        this.task = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.checkIdlePlayers(), 5L, 5L);
    }

    private void checkIdlePlayers() {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOnline()) continue;
            UUID playerId = player.getUniqueId();
            PlayerActivityData activityData = this.playerActivityMap.get(playerId);
            if (activityData == null) {
                activityData = new PlayerActivityData();
                activityData.lastActivityTime = currentTime;
                activityData.isIdle = false;
                activityData.originalSimulationDistance = this.getPlayerSimulationDistance(player);
                this.playerActivityMap.put(playerId, activityData);
                continue;
            }
            long timeSinceLastActivity = currentTime - activityData.lastActivityTime;
            long idleThresholdMs = this.idleThresholdTicks * 50L;
            if (!activityData.isIdle && timeSinceLastActivity >= idleThresholdMs) {
                this.setPlayerIdle(player, activityData);
                continue;
            }
            if (!activityData.isIdle || timeSinceLastActivity >= idleThresholdMs) continue;
            this.setPlayerActive(player, activityData);
        }
    }

    private void setPlayerIdle(Player player, PlayerActivityData activityData) {
        activityData.isIdle = true;
        this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, player.getLocation(), () -> {
            if (player.isOnline()) {
                this.setPlayerSimulationDistance(player, this.idleSimulationDistance);
                if (this.debugMode) {
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Player " + player.getName() + " is now idle, simulation distance set to " + this.idleSimulationDistance)).color(TextColor.color((int)0xFFFF00))));
                }
            }
        });
    }

    private void setPlayerActive(Player player, PlayerActivityData activityData) {
        activityData.isIdle = false;
        this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, player.getLocation(), () -> {
            if (player.isOnline()) {
                this.setPlayerSimulationDistance(player, activityData.originalSimulationDistance);
                if (this.debugMode) {
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Player " + player.getName() + " is now active, simulation distance restored to " + activityData.originalSimulationDistance)).color(TextColor.color((int)65280))));
                }
            }
        });
    }

    private void updatePlayerActivity(Player player) {
        if (!this.idleSimulationDistanceEnabled) {
            return;
        }
        UUID playerId = player.getUniqueId();
        PlayerActivityData activityData = this.playerActivityMap.computeIfAbsent(playerId, k -> {
            PlayerActivityData data = new PlayerActivityData();
            data.originalSimulationDistance = this.getPlayerSimulationDistance(player);
            return data;
        });
        activityData.lastActivityTime = System.currentTimeMillis();
        if (activityData.isIdle) {
            this.setPlayerActive(player, activityData);
        }
    }

    private int getPlayerSimulationDistance(Player player) {
        try {
            return player.getSimulationDistance();
        }
        catch (Exception e) {
            return this.defaultSimulationDistance;
        }
    }

    private void setPlayerSimulationDistance(Player player, int distance) {
        block2: {
            try {
                player.setSimulationDistance(distance);
            }
            catch (Exception e) {
                if (!this.debugMode) break block2;
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Failed to set simulation distance for " + player.getName() + ": " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().distanceSquared(event.getTo()) > 0.01) {
            this.updatePlayerActivity(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.updatePlayerActivity(event.getPlayer());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.updatePlayerActivity(event.getPlayer());
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        this.updatePlayerActivity(event.getPlayer());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            this.updatePlayerActivity(player);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.updatePlayerActivity(event.getPlayer());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.updatePlayerActivity(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        PlayerActivityData activityData = new PlayerActivityData();
        activityData.lastActivityTime = System.currentTimeMillis();
        activityData.isIdle = false;
        activityData.originalSimulationDistance = this.getPlayerSimulationDistance(player);
        this.playerActivityMap.put(playerId, activityData);
        if (this.debugMode) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Player " + player.getName() + " joined, tracking activity")).color(TextColor.color((int)65280))));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.playerActivityMap.remove(playerId);
        if (this.debugMode) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Player " + event.getPlayer().getName() + " left, stopped tracking activity")).color(TextColor.color((int)0xFFFF00))));
        }
    }

    public void shutdown() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        for (Map.Entry<UUID, PlayerActivityData> entry : this.playerActivityMap.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            PlayerActivityData data = entry.getValue();
            if (!data.isIdle) continue;
            this.setPlayerSimulationDistance(player, data.originalSimulationDistance);
        }
        this.playerActivityMap.clear();
    }

    public boolean isEnabled() {
        return this.idleSimulationDistanceEnabled;
    }

    public int getActivePlayerCount() {
        return (int)this.playerActivityMap.values().stream().filter(data -> !data.isIdle).count();
    }

    public int getIdlePlayerCount() {
        return (int)this.playerActivityMap.values().stream().filter(data -> data.isIdle).count();
    }

    private static class PlayerActivityData {
        long lastActivityTime;
        boolean isIdle;
        int originalSimulationDistance;

        private PlayerActivityData() {
        }
    }
}

