/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.redstone;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import me.bloodred.perfobooster.util.TPSMonitor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

public class DeactivateRedstone
implements Listener {
    private final PerfoBooster plugin;
    private final TPSMonitor tpsMonitor;
    private boolean enabled;
    private double deactivationTpsThreshold;
    private double activationTpsThreshold;
    private boolean circuitBreakerEnabled;
    private boolean redstoneDeactivated = false;
    private long lastActivationTime = 0L;
    private long circuitBreakerDelay = 30000L;
    private int circuitBreakerTriggerCount = 0;
    private final int maxCircuitBreakerTriggers = 3;
    private ScheduledTask monitoringTask;
    private final ConcurrentHashMap<String, Long> worldLastDeactivationLog = new ConcurrentHashMap();
    private final long logCooldownMs = 60000L;

    public DeactivateRedstone(PerfoBooster plugin) {
        this.plugin = plugin;
        this.tpsMonitor = plugin.getTpsMonitor();
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startMonitoring();
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("redstoneOptimization.deactivateRedstone.enabled", true);
        if (!this.enabled) {
            return;
        }
        this.deactivationTpsThreshold = this.plugin.getConfig().getDouble("redstoneOptimization.deactivateRedstone.deactivationTpsThreshold", 15.0);
        this.activationTpsThreshold = this.plugin.getConfig().getDouble("redstoneOptimization.deactivateRedstone.activationTpsThreshold", 18.0);
        this.circuitBreakerEnabled = this.plugin.getConfig().getBoolean("redstoneOptimization.deactivateRedstone.circuitBreaker.enabled", true);
        this.circuitBreakerDelay = this.plugin.getConfig().getLong("redstoneOptimization.deactivateRedstone.circuitBreaker.delayMs", 30000L);
        if (this.deactivationTpsThreshold >= this.activationTpsThreshold) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Warning: DeactivateRedstone deactivation threshold (" + this.deactivationTpsThreshold + ") should be lower than activation threshold (" + this.activationTpsThreshold + ")")).color(TextColor.color((int)0xFFFF00))));
        }
    }

    private void startMonitoring() {
        if (!this.enabled) {
            return;
        }
        this.monitoringTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            double currentTps = this.tpsMonitor.getGlobalTps();
            long currentTime = System.currentTimeMillis();
            if (!this.redstoneDeactivated && currentTps <= this.deactivationTpsThreshold) {
                this.redstoneDeactivated = true;
                this.circuitBreakerTriggerCount = 0;
                this.logDeactivation("Redstone deactivated due to low TPS: " + String.format("%.1f", currentTps));
            } else if (this.redstoneDeactivated && currentTps >= this.activationTpsThreshold) {
                if (this.circuitBreakerEnabled && currentTime - this.lastActivationTime < this.circuitBreakerDelay && this.circuitBreakerTriggerCount < 3) {
                    ++this.circuitBreakerTriggerCount;
                    this.logDeactivation("Circuit breaker triggered (" + this.circuitBreakerTriggerCount + "/3) - delaying redstone activation");
                    return;
                }
                this.redstoneDeactivated = false;
                this.lastActivationTime = currentTime;
                this.circuitBreakerTriggerCount = 0;
                this.logDeactivation("Redstone reactivated due to improved TPS: " + String.format("%.1f", currentTps));
            }
        }, 40L, 40L, TimeUnit.SECONDS);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        if (!this.enabled || !this.redstoneDeactivated) {
            return;
        }
        event.setNewCurrent(0);
        if (this.plugin.getConfig().getBoolean("redstoneOptimization.deactivateRedstone.debug", false)) {
            Location loc = event.getBlock().getLocation();
            String worldName = loc.getWorld().getName();
            long currentTime = System.currentTimeMillis();
            Long lastLog = this.worldLastDeactivationLog.get(worldName);
            if (lastLog == null || currentTime - lastLog > 60000L) {
                this.worldLastDeactivationLog.put(worldName, currentTime);
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Blocked redstone activity in world: " + worldName + " at " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ())).color(TextColor.color((int)0xFF8800))));
            }
        }
    }

    private void logDeactivation(String message) {
        if (this.plugin.getConfig().getBoolean("redstoneOptimization.deactivateRedstone.silent", false)) {
            return;
        }
        this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)message).color(this.redstoneDeactivated ? TextColor.color((int)0xFF0000) : TextColor.color((int)65280))));
    }

    public void shutdown() {
        if (this.monitoringTask != null && !this.monitoringTask.isCancelled()) {
            this.monitoringTask.cancel();
        }
        this.worldLastDeactivationLog.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRedstoneDeactivated() {
        return this.redstoneDeactivated;
    }

    public double getDeactivationTpsThreshold() {
        return this.deactivationTpsThreshold;
    }

    public double getActivationTpsThreshold() {
        return this.activationTpsThreshold;
    }

    public boolean isCircuitBreakerEnabled() {
        return this.circuitBreakerEnabled;
    }

    public int getCircuitBreakerTriggerCount() {
        return this.circuitBreakerTriggerCount;
    }

    public long getCircuitBreakerDelay() {
        return this.circuitBreakerDelay;
    }

    public void forceDeactivate() {
        this.redstoneDeactivated = true;
        this.logDeactivation("Redstone manually deactivated");
    }

    public void forceActivate() {
        this.redstoneDeactivated = false;
        this.lastActivationTime = System.currentTimeMillis();
        this.circuitBreakerTriggerCount = 0;
        this.logDeactivation("Redstone manually activated");
    }

    public void resetCircuitBreaker() {
        this.circuitBreakerTriggerCount = 0;
        this.lastActivationTime = 0L;
        this.logDeactivation("Circuit breaker reset");
    }
}

