/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.redstone;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerAntiSpam
implements Listener {
    private final PerfoBooster plugin;
    private boolean playerAntiSpamEnabled;
    private int maxInteractions;
    private long resetPeriodMillis;
    private boolean useActionBar;
    private final ConcurrentHashMap<UUID, PlayerSpamData> playerData = new ConcurrentHashMap();
    private ScheduledTask blacklistCleanupTask;

    public PlayerAntiSpam(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.playerAntiSpamEnabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startScheduledTasks();
        }
    }

    private void loadConfig() {
        this.playerAntiSpamEnabled = this.plugin.getConfig().getBoolean("redstoneOptimization.playerAntiSpam.enabled", true);
        if (!this.playerAntiSpamEnabled) {
            return;
        }
        this.maxInteractions = this.plugin.getConfig().getInt("redstoneOptimization.playerAntiSpam.maxInteractions", 15);
        int resetPeriodTicks = this.plugin.getConfig().getInt("redstoneOptimization.playerAntiSpam.resetPeriod", 20);
        this.resetPeriodMillis = (long)resetPeriodTicks * 50L;
        this.useActionBar = this.plugin.getConfig().getBoolean("redstoneOptimization.playerAntiSpam.useActionBar", true);
    }

    private void startScheduledTasks() {
        if (!this.playerAntiSpamEnabled) {
            return;
        }
        this.blacklistCleanupTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            long currentTime = System.currentTimeMillis();
            this.playerData.entrySet().removeIf(entry -> {
                PlayerSpamData data = (PlayerSpamData)entry.getValue();
                UUID playerId = (UUID)entry.getKey();
                if (!data.isBlacklisted && currentTime - data.lastInteraction > 30000L) {
                    return true;
                }
                if (data.isBlacklisted && currentTime >= data.blacklistedUntil) {
                    data.isBlacklisted = false;
                    data.interactions = 0;
                    data.blacklistedUntil = 0L;
                    data.notificationSent = false;
                    Player player = this.plugin.getServer().getPlayer(playerId);
                    if (player != null && player.isOnline()) {
                        this.sendMessage(player, "\u00a7aYou can now use redstone again!");
                    }
                    return false;
                }
                return false;
            });
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.playerAntiSpamEnabled || event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK || event.getClickedBlock() == null || !PlayerAntiSpam.isRedstoneRelated(event.getClickedBlock().getType().name())) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        PlayerSpamData data = this.playerData.computeIfAbsent(playerId, k -> new PlayerSpamData());
        if (data.isBlacklisted) {
            if (currentTime >= data.blacklistedUntil) {
                data.isBlacklisted = false;
                data.interactions = 0;
                data.blacklistedUntil = 0L;
                data.notificationSent = false;
                this.sendMessage(player, "\u00a7aYou can now use redstone again!");
            } else {
                event.setCancelled(true);
                if (!data.notificationSent) {
                    long remainingSeconds = (data.blacklistedUntil - currentTime) / 1000L;
                    this.sendMessage(player, "\u00a7cYou are temporarily blocked from using redstone! " + remainingSeconds + " seconds remaining.");
                    data.notificationSent = true;
                }
                return;
            }
        }
        if (currentTime - data.lastInteraction > 1000L) {
            data.interactions = 0;
        }
        ++data.interactions;
        data.lastInteraction = currentTime;
        if (data.interactions > this.maxInteractions) {
            data.isBlacklisted = true;
            data.blacklistedUntil = currentTime + this.resetPeriodMillis;
            data.interactions = 0;
            data.notificationSent = false;
            event.setCancelled(true);
            long blacklistSeconds = this.resetPeriodMillis / 1000L;
            this.sendMessage(player, "\u00a7cYou have been temporarily blocked from using redstone for " + blacklistSeconds + " seconds due to spam!");
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Player " + player.getName() + " has been blacklisted for redstone spam for " + blacklistSeconds + " seconds")).color(TextColor.color((int)0xFF0000))));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.playerAntiSpamEnabled) {
            return;
        }
        UUID playerId = event.getPlayer().getUniqueId();
        PlayerSpamData data = this.playerData.get(playerId);
        if (data != null && !data.isBlacklisted) {
            this.playerData.remove(playerId);
        }
    }

    private void sendMessage(Player player, String message) {
        if (this.useActionBar) {
            player.sendActionBar(message);
        } else {
            player.sendMessage(message);
        }
    }

    private static boolean isRedstoneRelated(String blockType) {
        String upperType = blockType.toUpperCase();
        return upperType.contains("REDSTONE") || upperType.contains("PISTON") || upperType.contains("BUTTON") || upperType.contains("LEVER") || upperType.contains("PRESSURE_PLATE") || upperType.contains("DOOR") || upperType.contains("TRAPDOOR") || upperType.contains("COMPARATOR") || upperType.contains("REPEATER") || upperType.contains("DISPENSER") || upperType.contains("DROPPER") || upperType.contains("HOPPER") || upperType.contains("OBSERVER") || upperType.contains("DAYLIGHT_DETECTOR") || upperType.contains("TNT");
    }

    public void shutdown() {
        if (this.blacklistCleanupTask != null && !this.blacklistCleanupTask.isCancelled()) {
            this.blacklistCleanupTask.cancel();
        }
        this.playerData.clear();
    }

    public boolean isEnabled() {
        return this.playerAntiSpamEnabled;
    }

    private static class PlayerSpamData {
        public int interactions = 0;
        public long lastInteraction = 0L;
        public long blacklistedUntil = 0L;
        public boolean isBlacklisted = false;
        public boolean notificationSent = false;

        private PlayerSpamData() {
        }
    }
}

