/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.redstone;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class RedstoneLimiter
implements Listener {
    private final PerfoBooster plugin;
    private boolean enabled;
    private int maxComponents;
    private int checkRadius;
    private boolean useActionBar;
    private Set<String> allowedInteractions;
    private ScheduledTask cacheCleanupTask;
    private final ConcurrentHashMap<String, Integer> componentCountCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> cacheTimestamps = new ConcurrentHashMap();
    private final long cacheExpirationMs = 10000L;
    private static final EnumSet<Material> REDSTONE_MATERIALS = EnumSet.of(Material.REDSTONE_WIRE, new Material[]{Material.REDSTONE_TORCH, Material.REDSTONE_WALL_TORCH, Material.REDSTONE_BLOCK, Material.REDSTONE_LAMP, Material.REPEATER, Material.COMPARATOR, Material.PISTON, Material.STICKY_PISTON, Material.DISPENSER, Material.DROPPER, Material.HOPPER, Material.OBSERVER, Material.DAYLIGHT_DETECTOR, Material.TRIPWIRE_HOOK, Material.TNT, Material.NOTE_BLOCK, Material.JUKEBOX, Material.LEVER, Material.STONE_BUTTON, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.DARK_OAK_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON, Material.POLISHED_BLACKSTONE_BUTTON, Material.STONE_PRESSURE_PLATE, Material.OAK_PRESSURE_PLATE, Material.SPRUCE_PRESSURE_PLATE, Material.BIRCH_PRESSURE_PLATE, Material.JUNGLE_PRESSURE_PLATE, Material.ACACIA_PRESSURE_PLATE, Material.DARK_OAK_PRESSURE_PLATE, Material.CRIMSON_PRESSURE_PLATE, Material.WARPED_PRESSURE_PLATE, Material.LIGHT_WEIGHTED_PRESSURE_PLATE, Material.HEAVY_WEIGHTED_PRESSURE_PLATE, Material.POLISHED_BLACKSTONE_PRESSURE_PLATE, Material.ACTIVATOR_RAIL, Material.DETECTOR_RAIL, Material.POWERED_RAIL, Material.RAIL, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.TARGET, Material.LIGHTNING_ROD, Material.SCULK_SENSOR, Material.CALIBRATED_SCULK_SENSOR});

    public RedstoneLimiter(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            this.startCacheCleanup();
        }
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("redstoneOptimization.redstoneLimiter.enabled", true);
        if (!this.enabled) {
            return;
        }
        this.maxComponents = this.plugin.getConfig().getInt("redstoneOptimization.redstoneLimiter.maxComponents", 100);
        this.checkRadius = this.plugin.getConfig().getInt("redstoneOptimization.redstoneLimiter.checkRadius", 16);
        this.useActionBar = this.plugin.getConfig().getBoolean("redstoneOptimization.redstoneLimiter.useActionBar", true);
        this.allowedInteractions = new HashSet<String>(this.plugin.getConfig().getStringList("redstoneOptimization.redstoneLimiter.allowedInteractions"));
        if (this.maxComponents <= 0) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Warning: RedstoneLimiter maxComponents must be positive, using default value 100").color(TextColor.color((int)0xFFFF00))));
            this.maxComponents = 100;
        }
        if (this.checkRadius <= 0) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)"Warning: RedstoneLimiter checkRadius must be positive, using default value 16").color(TextColor.color((int)0xFFFF00))));
            this.checkRadius = 16;
        }
    }

    private void startCacheCleanup() {
        if (!this.enabled) {
            return;
        }
        this.cacheCleanupTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            long currentTime = System.currentTimeMillis();
            this.cacheTimestamps.entrySet().removeIf(entry -> {
                if (currentTime - (Long)entry.getValue() > 10000L) {
                    this.componentCountCache.remove(entry.getKey());
                    return true;
                }
                return false;
            });
        }, 600L, 600L, TimeUnit.SECONDS);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.enabled || !RedstoneLimiter.isRedstoneComponent(event.getBlock().getType())) {
            return;
        }
        Player player = event.getPlayer();
        Location location = event.getBlock().getLocation();
        if (this.isLimitExceeded(location)) {
            event.setCancelled(true);
            this.sendLimitMessage(player, "Cannot place redstone component: area limit exceeded!");
            this.invalidateCache(location);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.enabled || event.getClickedBlock() == null || event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!RedstoneLimiter.isRedstoneComponent(block.getType())) {
            return;
        }
        Player player = event.getPlayer();
        Location location = block.getLocation();
        if (this.allowedInteractions.contains("ALL")) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && this.allowedInteractions.contains("BREAK")) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && this.allowedInteractions.contains("RIGHT_CLICK")) {
            return;
        }
        if (this.isLimitExceeded(location)) {
            event.setCancelled(true);
            this.sendLimitMessage(player, "Cannot interact with redstone: area limit exceeded!");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        if (!this.enabled) {
            return;
        }
        Location location = event.getBlock().getLocation();
        if (this.isLimitExceeded(location)) {
            event.setNewCurrent(0);
        }
    }

    private boolean isLimitExceeded(Location location) {
        Integer cachedCount;
        String cacheKey = this.getCacheKey(location);
        long currentTime = System.currentTimeMillis();
        Long cacheTime = this.cacheTimestamps.get(cacheKey);
        if (cacheTime != null && currentTime - cacheTime < 10000L && (cachedCount = this.componentCountCache.get(cacheKey)) != null) {
            return cachedCount >= this.maxComponents;
        }
        int componentCount = this.countRedstoneComponents(location);
        this.componentCountCache.put(cacheKey, componentCount);
        this.cacheTimestamps.put(cacheKey, currentTime);
        return componentCount >= this.maxComponents;
    }

    private int countRedstoneComponents(Location location) {
        int count = 0;
        int centerX = location.getBlockX();
        int centerY = location.getBlockY();
        int centerZ = location.getBlockZ();
        for (int x = centerX - this.checkRadius; x <= centerX + this.checkRadius; ++x) {
            for (int z = centerZ - this.checkRadius; z <= centerZ + this.checkRadius; ++z) {
                for (int y = Math.max(location.getWorld().getMinHeight(), centerY - this.checkRadius); y <= Math.min(location.getWorld().getMaxHeight() - 1, centerY + this.checkRadius); ++y) {
                    Block block;
                    Material material;
                    double distance = Math.sqrt(Math.pow(x - centerX, 2.0) + Math.pow(y - centerY, 2.0) + Math.pow(z - centerZ, 2.0));
                    if (!(distance <= (double)this.checkRadius) || (material = (block = location.getWorld().getBlockAt(x, y, z)).getType()) == Material.AIR || !RedstoneLimiter.isRedstoneComponent(material)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private String getCacheKey(Location location) {
        return location.getWorld().getName() + "_" + location.getBlockX() + "_" + location.getBlockY() + "_" + location.getBlockZ();
    }

    private void invalidateCache(Location location) {
        String cacheKey = this.getCacheKey(location);
        this.componentCountCache.remove(cacheKey);
        this.cacheTimestamps.remove(cacheKey);
        int centerX = location.getBlockX();
        int centerY = location.getBlockY();
        int centerZ = location.getBlockZ();
        String worldName = location.getWorld().getName();
        this.componentCountCache.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith(worldName + "_")) {
                try {
                    String[] parts = key.split("_");
                    if (parts.length >= 4) {
                        int x = Integer.parseInt(parts[1]);
                        int y = Integer.parseInt(parts[2]);
                        int z = Integer.parseInt(parts[3]);
                        double distance = Math.sqrt(Math.pow(x - centerX, 2.0) + Math.pow(y - centerY, 2.0) + Math.pow(z - centerZ, 2.0));
                        if (distance <= (double)(this.checkRadius * 2)) {
                            this.cacheTimestamps.remove(key);
                            return true;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        });
    }

    private void sendLimitMessage(Player player, String message) {
        String formattedMessage = "\u00a7c" + message;
        if (this.useActionBar) {
            player.sendActionBar(formattedMessage);
        } else {
            player.sendMessage(formattedMessage);
        }
    }

    private static boolean isRedstoneComponent(Material material) {
        return REDSTONE_MATERIALS.contains(material);
    }

    public void shutdown() {
        if (this.cacheCleanupTask != null && !this.cacheCleanupTask.isCancelled()) {
            this.cacheCleanupTask.cancel();
        }
        this.componentCountCache.clear();
        this.cacheTimestamps.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public int getCheckRadius() {
        return this.checkRadius;
    }

    public boolean isUseActionBar() {
        return this.useActionBar;
    }

    public Set<String> getAllowedInteractions() {
        return this.allowedInteractions;
    }

    public int getCacheSize() {
        return this.componentCountCache.size();
    }

    public void clearCache() {
        this.componentCountCache.clear();
        this.cacheTimestamps.clear();
    }
}

