/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.registrar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.bloodred.perfobooster.PerfoBooster;
import me.bloodred.perfobooster.PerfoBoosterCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyCommand {
    private final PerfoBooster plugin;
    private final PerfoBoosterCommand commandHandler;

    public LegacyCommand(PerfoBooster plugin, PerfoBoosterCommand commandHandler) {
        this.plugin = plugin;
        this.commandHandler = commandHandler;
    }

    public void registerCommands() {
        PerfoBoosterBukkitCommand mainCommand = new PerfoBoosterBukkitCommand();
        this.plugin.getServer().getCommandMap().register("perfobooster", (Command)mainCommand);
        this.plugin.getServer().getCommandMap().register("pb", (Command)new AliasBukkitCommand("pb", mainCommand));
        this.plugin.getServer().getCommandMap().register("perfob", (Command)new AliasBukkitCommand("perfob", mainCommand));
    }

    private class PerfoBoosterBukkitCommand
    extends BukkitCommand {
        public PerfoBoosterBukkitCommand() {
            super("perfobooster", "Main command for PerfoBooster", "/perfobooster [reload|status|gc|load|sysinfo|update|info]", Arrays.asList("pb", "perfob"));
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
            String subCommand;
            if (!sender.hasPermission("perfobooster.command")) {
                sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to use this command!").color(TextColor.color((int)0xFF0000))));
                return true;
            }
            if (args.length == 0) {
                LegacyCommand.this.commandHandler.sendHelp(sender);
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "reload": {
                    if (!sender.hasPermission("perfobooster.reload")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to reload the plugin!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleReload(sender);
                    break;
                }
                case "status": {
                    if (!sender.hasPermission("perfobooster.status")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to check status!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleStatus(sender);
                    break;
                }
                case "gc": {
                    if (!sender.hasPermission("perfobooster.gc")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to run garbage collection!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleGarbageCollection(sender);
                    break;
                }
                case "load": {
                    if (!sender.hasPermission("perfobooster.load")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to check server load!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleServerLoad(sender);
                    break;
                }
                case "sysinfo": {
                    if (!sender.hasPermission("perfobooster.sysinfo")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to check system info!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleSystemInfo(sender);
                    break;
                }
                case "update": {
                    if (!sender.hasPermission("perfobooster.update")) {
                        sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to check updates!").color(TextColor.color((int)0xFF0000))));
                        return true;
                    }
                    LegacyCommand.this.commandHandler.handleUpdate(sender, args);
                    break;
                }
                case "info": {
                    LegacyCommand.this.commandHandler.handleInfo(sender);
                    break;
                }
                default: {
                    LegacyCommand.this.commandHandler.sendHelp(sender);
                }
            }
            return true;
        }

        @Nullable
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            ArrayList<String> completions = new ArrayList<String>();
            if (!sender.hasPermission("perfobooster.command")) {
                return completions;
            }
            if (args.length == 1) {
                String partial = args[0].toLowerCase();
                if (sender.hasPermission("perfobooster.reload") && "reload".startsWith(partial)) {
                    completions.add("reload");
                }
                if (sender.hasPermission("perfobooster.status") && "status".startsWith(partial)) {
                    completions.add("status");
                }
                if (sender.hasPermission("perfobooster.gc") && "gc".startsWith(partial)) {
                    completions.add("gc");
                }
                if (sender.hasPermission("perfobooster.load") && "load".startsWith(partial)) {
                    completions.add("load");
                }
                if (sender.hasPermission("perfobooster.sysinfo") && "sysinfo".startsWith(partial)) {
                    completions.add("sysinfo");
                }
                if (sender.hasPermission("perfobooster.update") && "update".startsWith(partial)) {
                    completions.add("update");
                }
                if ("info".startsWith(partial)) {
                    completions.add("info");
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("update")) {
                if (sender.hasPermission("perfobooster.update") && "check".startsWith(args[1].toLowerCase())) {
                    completions.add("check");
                }
                if (sender.hasPermission("perfobooster.admin") && "download".startsWith(args[1].toLowerCase())) {
                    completions.add("download");
                }
            }
            return completions;
        }
    }

    private static class AliasBukkitCommand
    extends BukkitCommand {
        private final PerfoBoosterBukkitCommand parentCommand;

        public AliasBukkitCommand(String name, PerfoBoosterBukkitCommand parentCommand) {
            super(name, "Alias for PerfoBooster command", "/" + name + " [reload|status|gc|load|sysinfo|update|info]", List.of());
            this.parentCommand = parentCommand;
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
            return this.parentCommand.execute(sender, "perfobooster", args);
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            ArrayList result = this.parentCommand.tabComplete(sender, alias, args);
            return result != null ? result : new ArrayList();
        }
    }
}

