/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.perfobooster.tick;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import me.bloodred.perfobooster.PerfoBooster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LaggyChunkUnloader {
    private final PerfoBooster plugin;
    private boolean unloadLaggyChunksEnabled;
    private int playerProximityThreshold;
    private int checkInterval;
    private int maxTileEntityUpdates;
    private final Map<String, Integer> chunkUpdateCounts = new HashMap<String, Integer>();
    private ScheduledTask task;

    public LaggyChunkUnloader(PerfoBooster plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.unloadLaggyChunksEnabled) {
            this.startLaggyChunkTask();
        }
    }

    private void loadConfig() {
        this.unloadLaggyChunksEnabled = this.plugin.getConfig().getBoolean("worldTickManagement.unloadLaggyChunks.enabled", true);
        if (!this.unloadLaggyChunksEnabled) {
            return;
        }
        this.playerProximityThreshold = this.plugin.getConfig().getInt("worldTickManagement.unloadLaggyChunks.playerProximityThreshold", 128);
        this.checkInterval = this.plugin.getConfig().getInt("worldTickManagement.unloadLaggyChunks.checkInterval", 60);
        this.maxTileEntityUpdates = this.plugin.getConfig().getInt("worldTickManagement.unloadLaggyChunks.maxTileEntityUpdates", 500);
    }

    private void startLaggyChunkTask() {
        if (!this.unloadLaggyChunksEnabled) {
            return;
        }
        this.task = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, t -> this.detectAndUnloadLaggyChunks(), 20L * (long)this.checkInterval, (long)this.checkInterval * 20L);
    }

    private void detectAndUnloadLaggyChunks() {
        if (!this.unloadLaggyChunksEnabled) {
            return;
        }
        HashMap<String, Integer> currentUpdateCounts = new HashMap<String, Integer>(this.chunkUpdateCounts);
        this.chunkUpdateCounts.clear();
        for (World world : Bukkit.getWorlds()) {
            Location spawnLocation = world.getSpawnLocation();
            if (spawnLocation == null) {
                spawnLocation = new Location(world, 0.0, 64.0, 0.0);
            }
            this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, spawnLocation, () -> {
                for (Chunk chunk : world.getLoadedChunks()) {
                    String chunkKey;
                    int updateCount;
                    if (!chunk.isLoaded() || (updateCount = currentUpdateCounts.getOrDefault(chunkKey = world.getName() + ":" + chunk.getX() + ":" + chunk.getZ(), 0).intValue()) <= this.maxTileEntityUpdates) continue;
                    boolean playerNearby = false;
                    for (Player player : world.getPlayers()) {
                        if (!player.isOnline() || player.getLocation().getWorld() == null || !player.getLocation().getWorld().equals((Object)world)) continue;
                        int playerChunkX = player.getLocation().getBlockX() >> 4;
                        int playerChunkZ = player.getLocation().getBlockZ() >> 4;
                        double distance = Math.sqrt(Math.pow(playerChunkX - chunk.getX(), 2.0) + Math.pow(playerChunkZ - chunk.getZ(), 2.0)) * 16.0;
                        if (!(distance <= (double)this.playerProximityThreshold)) continue;
                        playerNearby = true;
                        break;
                    }
                    if (playerNearby || !chunk.isLoaded() || chunk.isForceLoaded()) continue;
                    Chunk c = chunk;
                    String finalChunkKey = chunkKey;
                    int finalUpdateCount = updateCount;
                    Location chunkLocation = new Location(world, (double)(c.getX() << 4), 64.0, (double)(c.getZ() << 4));
                    this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, chunkLocation, () -> {
                        if (c.isLoaded()) {
                            c.unload(true);
                            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Unloaded laggy chunk at " + finalChunkKey + " with " + finalUpdateCount + " updates")).color(TextColor.color((int)0xFFFF00))));
                        }
                    });
                }
            });
        }
    }

    public void trackTileEntityUpdate(BlockState blockState) {
        if (!this.unloadLaggyChunksEnabled || blockState == null || blockState.getWorld() == null || blockState.getChunk() == null) {
            return;
        }
        Chunk chunk = blockState.getChunk();
        String chunkKey = blockState.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
        this.chunkUpdateCounts.put(chunkKey, this.chunkUpdateCounts.getOrDefault(chunkKey, 0) + 1);
    }

    public void shutdown() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        this.chunkUpdateCounts.clear();
    }

    public boolean isEnabled() {
        return this.unloadLaggyChunksEnabled;
    }
}

