/*
 * Decompiled with CFR 0.152.
 */
package me.violine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;

public record CopperData(String simpleId, CopperStage stage, boolean waxed) {
    private static final List<String> BLOCK_NAMES = List.of("chiseled_copper", "copper", "copper_bars", "copper_bulb", "copper_chain", "copper_chest", "copper_door", "copper_golem_statue", "copper_grate", "copper_lantern", "copper_trapdoor", "cut_copper", "cut_copper_slab", "cut_copper_stairs", "lightning_rod");
    private static final HashMap<String, CopperData> DATA = HashMap.newHashMap(BLOCK_NAMES.size() * CopperStage.values().length * 2);

    public String getDescriptiveId() {
        String BLOCK_PREFIX = "block.minecraft.";
        String WAXED_PREFIX = "waxed_";
        boolean isNonStandardId = this.simpleId.equals("copper") && this.stage == CopperStage.UNOXIDIZED;
        String simpleId = isNonStandardId ? "copper_block" : this.simpleId;
        return "block.minecraft." + (this.waxed ? "waxed_" : "") + this.stage.getPrefix() + simpleId;
    }

    public ArrayList<String> getTooltipTranslationKeys() {
        String TRANSLATE_KEY_PREFIX = "copper-tooltips.";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("copper-tooltips.stage." + this.stage.toString());
        if (this.waxed) {
            keys.add("copper-tooltips.waxed");
        }
        return keys;
    }

    public CopperData getMain() {
        return new CopperData(this.simpleId, CopperStage.UNOXIDIZED, false);
    }

    public static Optional<CopperData> get(class_1792 item) {
        String id = item.method_7876();
        return Optional.ofNullable(DATA.get(id));
    }

    static {
        for (CopperStage stage : CopperStage.values()) {
            for (String blockName : BLOCK_NAMES) {
                CopperData unwaxedData = new CopperData(blockName, stage, false);
                DATA.put(unwaxedData.getDescriptiveId(), unwaxedData);
                CopperData waxedData = new CopperData(blockName, stage, true);
                DATA.put(waxedData.getDescriptiveId(), waxedData);
            }
        }
    }

    public static enum CopperStage {
        UNOXIDIZED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;


        public String getPrefix() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "";
                case 1 -> "exposed_";
                case 2 -> "weathered_";
                case 3 -> "oxidized_";
            };
        }

        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "unoxidized";
                case 1 -> "exposed";
                case 2 -> "weathered";
                case 3 -> "oxidized";
            };
        }
    }
}

