/*
 * Decompiled with CFR 0.152.
 */
package StackSpawners;

import StackSpawners.PlData.JsonSimple;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StackSpawners
extends JavaPlugin
implements Listener {
    private String prefix = ChatColor.GOLD + "X";
    private int maxEntity = 128;
    private int maxSpawner = 64;
    private int mobStackRadius = 3;
    private int period = 400;
    private boolean abort = true;
    private boolean mobSpawnDeny = false;
    private Map<String, String> spawnernames = new HashMap<String, String>();
    private Map<String, Integer> spawnerStacks = null;
    private YamlConfiguration newConfigz;

    public void onEnable() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.getLogger().info("\n\r\nStackSpawners by MrMarL");
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        Plugin holographicsDisplays = this.getServer().getPluginManager().getPlugin("DecentHolograms");
        if (holographicsDisplays == null) {
            this.getLogger().severe("DecentHolograms was not found. The plugin will not work.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.Datafile();
        this.Settingsfile();
        this.reTask();
    }

    public void reTask() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)new EmuletedSpawner(), 120L, (long)this.period);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getPlayer().isSneaking()) {
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock == null || clickedBlock.getType() != Material.SPAWNER) {
                return;
            }
            ItemStack heldItem = event.getItem();
            if (heldItem == null || heldItem.getType() != Material.SPAWNER) {
                return;
            }
            event.setCancelled(true);
            BlockStateMeta bsm = (BlockStateMeta)heldItem.getItemMeta();
            CreatureSpawner cs1 = (CreatureSpawner)bsm.getBlockState();
            CreatureSpawner cs2 = (CreatureSpawner)clickedBlock.getState();
            if (cs1.getSpawnedType() != cs2.getSpawnedType()) {
                return;
            }
            Location blockLocation = clickedBlock.getLocation();
            String key = StackSpawners.getStringLocation(blockLocation);
            if (this.spawnerStacks.containsKey(key)) {
                int count = this.spawnerStacks.get(key);
                if (count >= this.maxSpawner) {
                    return;
                }
                this.spawnerStacks.put(key, count + 1);
            } else {
                this.spawnerStacks.put(key, 2);
            }
            this.updateSpawnerHologram(blockLocation, this.spawnerStacks.get(key));
            heldItem.setAmount(heldItem.getAmount() - 1);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        BlockStateMeta bsm;
        CreatureSpawner cs;
        EntityType type;
        Block block = event.getBlock();
        ItemStack item = event.getItemInHand();
        if (block.getType() == Material.SPAWNER && item.hasItemMeta() && (type = (cs = (CreatureSpawner)(bsm = (BlockStateMeta)item.getItemMeta()).getBlockState()).getSpawnedType()) != null) {
            CreatureSpawner spawner = (CreatureSpawner)block.getState();
            spawner.setSpawnedType(type);
            spawner.update();
            String key = StackSpawners.getStringLocation(spawner.getLocation());
            if (this.spawnerStacks.containsKey(key)) {
                return;
            }
            this.spawnerStacks.put(key, 1);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        final Block block = event.getBlock();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        event.setCancelled(true);
        final Location blockLocation = block.getLocation();
        String key = StackSpawners.getStringLocation(blockLocation);
        final CreatureSpawner cs = (CreatureSpawner)block.getState();
        if (this.spawnerStacks.containsKey(key)) {
            int stackCount = this.spawnerStacks.get(key);
            if (stackCount > 1) {
                this.spawnerStacks.put(key, stackCount - 1);
                this.updateSpawnerHologram(blockLocation, stackCount - 1);
            } else {
                this.spawnerStacks.remove(key);
                block.setType(Material.AIR);
            }
        } else {
            block.setType(Material.AIR);
        }
        new BukkitRunnable(this){
            final /* synthetic */ StackSpawners this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                ItemStack testSpawner = new ItemStack(Material.SPAWNER, 1);
                if (cs.getSpawnedType() != null) {
                    BlockStateMeta bsm = (BlockStateMeta)testSpawner.getItemMeta();
                    CreatureSpawner cs2 = (CreatureSpawner)bsm.getBlockState();
                    cs2.setSpawnedType(cs.getSpawnedType());
                    bsm.setBlockState((BlockState)cs2);
                    bsm.setDisplayName((String)this.this$0.spawnernames.get(cs.getSpawnedType().toString()));
                    testSpawner.setItemMeta((ItemMeta)bsm);
                }
                block.getWorld().dropItemNaturally(blockLocation, testSpawner);
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    public void forcedSpawnerSpawn(CreatureSpawner spawner) {
        String key;
        EntityType es;
        Location spawnerLocation = spawner.getLocation();
        Location targetLocation = this.findFreeSpace(spawnerLocation);
        LivingEntity oldentity = this.findMob(targetLocation, es = spawner.getSpawnedType());
        if (oldentity != null) {
            String key2;
            String name = oldentity.getCustomName();
            int stackCount = 1;
            if (name != null && name.contains(this.prefix)) {
                stackCount = Integer.parseInt(name.split(this.prefix)[1]);
            }
            stackCount = this.spawnerStacks.containsKey(key2 = StackSpawners.getStringLocation(spawnerLocation)) ? (stackCount += this.spawnerStacks.get(key2).intValue()) : ++stackCount;
            if (stackCount > this.maxEntity) {
                stackCount = this.maxEntity;
            }
            oldentity.setCustomName(String.format("%s%d", this.prefix, stackCount));
            oldentity.setCustomNameVisible(true);
            return;
        }
        Entity entity = spawner.getWorld().spawnEntity(targetLocation, es);
        if (this.abort && entity instanceof Ageable) {
            Ageable age = (Ageable)entity;
            age.setAdult();
        }
        if (entity instanceof Slime) {
            ((Slime)entity).setSize(0);
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).setAI(false);
        }
        if (entity.getVehicle() != null) {
            entity.getVehicle().remove();
        }
        if (this.spawnerStacks.containsKey(key = StackSpawners.getStringLocation(spawnerLocation))) {
            int stackCount = this.spawnerStacks.get(key);
            if (stackCount > this.maxEntity) {
                stackCount = this.maxEntity;
            }
            if (stackCount != 1) {
                entity.setCustomName(String.format("%s%d", this.prefix, stackCount));
                entity.setCustomNameVisible(true);
            }
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.mobSpawnDeny) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason == CreatureSpawnEvent.SpawnReason.NATURAL || reason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)event.getEntity();
        if (mob.getType() == EntityType.PLAYER) {
            return;
        }
        double damage = event.getFinalDamage();
        if (damage < mob.getHealth()) {
            return;
        }
        String name = mob.getCustomName();
        if (name != null && name.contains(this.prefix)) {
            int count = Integer.parseInt(name.split(this.prefix)[1]);
            LivingEntity newMob = (LivingEntity)mob.getWorld().spawnEntity(mob.getLocation(), mob.getType());
            newMob.setAI(false);
            if (this.abort && newMob instanceof Ageable) {
                Ageable age = (Ageable)newMob;
                age.setAdult();
            }
            if (newMob instanceof Slime) {
                ((Slime)newMob).setSize(0);
            }
            if (newMob.getVehicle() != null) {
                newMob.getVehicle().remove();
            }
            if (count > 2) {
                newMob.setCustomName(this.prefix + (count - 1));
                newMob.setCustomNameVisible(true);
            }
            newMob.damage(damage - mob.getHealth());
        }
    }

    @EventHandler
    public void onEndermanTeleport(EntityTeleportEvent event) {
        if (!(event.getEntity() instanceof Enderman)) {
            return;
        }
        Enderman enderman = (Enderman)event.getEntity();
        if (enderman.hasAI()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null) {
            return;
        }
        if (itemInHand.getType() != Material.NAME_TAG) {
            return;
        }
        String name = entity.getCustomName();
        if (name != null && name.contains(this.prefix)) {
            event.setCancelled(true);
        }
    }

    private Location findFreeSpace(Location blockLocation) {
        Location targetLocation = blockLocation.clone();
        targetLocation.add(0.5, -1.0, 0.5);
        if (targetLocation.getBlock().getType() == Material.AIR && targetLocation.add(0.0, -1.0, 0.0).getBlock().getType() == Material.AIR) {
            int i;
            for (i = 4; i > 0 && targetLocation.add(0.0, -1.0, 0.0).getBlock().getType() == Material.AIR; --i) {
            }
            if (i != 0) {
                return targetLocation.add(0.0, 1.0, 0.0);
            }
        }
        targetLocation.setY(blockLocation.getY() + 1.0);
        return targetLocation;
    }

    public LivingEntity findMob(Location location, EntityType mobType) {
        return location.getWorld().getNearbyEntities(location, (double)this.mobStackRadius, (double)this.mobStackRadius, (double)this.mobStackRadius).stream().filter(entity -> entity instanceof LivingEntity).filter(entity -> entity.getType() == mobType).map(entity -> (LivingEntity)entity).findFirst().orElse(null);
    }

    private void updateSpawnerHologram(Location location, int integer) {
        if (integer < 2) {
            this.removeSpawnerHologram(location);
            return;
        }
        location.add(0.5, 1.5, 0.5);
        Hologram dholo = DHAPI.getHologram((String)this.getHash(StackSpawners.getStringLocation(location)));
        if (dholo == null) {
            dholo = DHAPI.createHologram((String)this.getHash(StackSpawners.getStringLocation(location)), (Location)location);
        } else {
            DHAPI.removeHologramLine((Hologram)dholo, (int)0);
        }
        DHAPI.addHologramLine((Hologram)dholo, (int)0, (String)(this.prefix + integer));
    }

    private void removeSpawnerHologram(Location location) {
        location.add(0.5, 1.5, 0.5);
        Hologram dholo = DHAPI.getHologram((String)this.getHash(StackSpawners.getStringLocation(location)));
        if (dholo == null) {
            return;
        }
        dholo.delete();
    }

    public void onDisable() {
        this.saveData();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("stackspawners")) {
            String parametr;
            if (args.length == 0) {
                return true;
            }
            switch (parametr = args[0].toLowerCase()) {
                case "give": {
                    PlayerInventory inv;
                    Player p;
                    if (!sender.hasPermission("stackspawners.set")) {
                        sender.sendMessage("No perm");
                        return true;
                    }
                    if (args.length == 1) {
                        sender.sendMessage(String.format("%sinvalid format. try: /ss give 'nickname' 'item'", ChatColor.RED));
                        return true;
                    }
                    int i = 1;
                    if (args.length >= 3) {
                        p = Bukkit.getPlayer((String)args[1]);
                        if (p == null) {
                            sender.sendMessage("The player has not been found!!!");
                            return true;
                        }
                        inv = p.getInventory();
                        ++i;
                    } else {
                        p = (Player)sender;
                        inv = p.getInventory();
                    }
                    EntityType type = EntityType.fromName((String)args[i]);
                    if (type == null) {
                        return true;
                    }
                    ItemStack item = new ItemStack(Material.SPAWNER);
                    BlockStateMeta bsm = (BlockStateMeta)item.getItemMeta();
                    CreatureSpawner cs = (CreatureSpawner)bsm.getBlockState();
                    cs.setSpawnedType(type);
                    bsm.setBlockState((BlockState)cs);
                    bsm.setDisplayName(this.spawnernames.get(type.toString()));
                    item.setItemMeta((ItemMeta)bsm);
                    int temp = 1;
                    if (args.length >= 4) {
                        try {
                            temp = Integer.parseInt(args[3]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    while (0 < temp--) {
                        inv.addItem(new ItemStack[]{item});
                    }
                    return true;
                }
                case "reload": {
                    sender.sendMessage(String.format("%sReloading Plugin.", ChatColor.YELLOW));
                    this.Settingsfile();
                    this.reTask();
                    return true;
                }
            }
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Error.");
        return false;
    }

    private void Settingsfile() {
        File settings = new File(this.getDataFolder(), "settings.yml");
        if (!settings.exists()) {
            this.saveResource("settings.yml", false);
        }
        this.newConfigz = YamlConfiguration.loadConfiguration((File)settings);
        this.maxEntity = this.Check("maxEntity", this.maxEntity);
        this.maxSpawner = this.Check("maxSpawner", this.maxSpawner);
        this.mobStackRadius = this.Check("mobStackRadius", this.mobStackRadius);
        this.abort = this.Check("abort", this.abort);
        this.period = this.Check("period", this.period);
        this.mobSpawnDeny = this.Check("mobSpawnDeny", this.mobSpawnDeny);
        this.spawnernames.clear();
        for (EntityType type : EntityType.values()) {
            this.spawnernames.put(type.toString(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.Check(type.toString(), type.toString())));
        }
    }

    int Check(String type, int data) {
        if (!this.newConfigz.isInt(type)) {
            this.newConfigz.set(type, (Object)data);
        }
        return this.newConfigz.getInt(type);
    }

    String Check(String type, String data) {
        if (!this.newConfigz.isString(type)) {
            this.newConfigz.set(type, (Object)data);
        }
        return this.newConfigz.getString(type);
    }

    boolean Check(String type, boolean data) {
        if (!this.newConfigz.isBoolean(type)) {
            this.newConfigz.set(type, (Object)data);
        }
        return this.newConfigz.getBoolean(type);
    }

    private void Datafile() {
        File PlData = new File(this.getDataFolder(), "Data.json");
        this.spawnerStacks = PlData.exists() ? JsonSimple.Read(PlData) : new HashMap<String, Integer>();
        try {
            new BukkitRunnable(){

                public void run() {
                    ArrayList<String> removed = new ArrayList<String>();
                    for (Map.Entry entry : StackSpawners.this.spawnerStacks.entrySet()) {
                        Location loc = StackSpawners.getLocationString((String)entry.getKey());
                        if (loc.getBlock().getType() != Material.SPAWNER) {
                            removed.add((String)entry.getKey());
                            continue;
                        }
                        StackSpawners.this.updateSpawnerHologram(loc, (Integer)entry.getValue());
                    }
                    for (String rem : removed) {
                        StackSpawners.this.spawnerStacks.remove(rem);
                    }
                }
            }.runTaskLater((Plugin)this, 100L);
        }
        catch (Exception e) {
            this.getLogger().info("\u0427\u0451\u0442 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0435 \u043f\u043e\u0434\u0442\u044f\u043d\u0443\u043b\u0438\u0441\u044c :-/");
        }
    }

    public void saveData() {
        try {
            File PlData = new File(this.getDataFolder(), "Data.json");
            JsonSimple.Write(this.spawnerStacks, PlData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (!sender.hasPermission("spawnerroxy.set")) {
            return commands;
        }
        if (args.length == 1) {
            commands.addAll(Arrays.asList("give", "reload"));
        } else if (args.length == 2) {
            if (args[0].equals("give")) {
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    commands.add(pl.getName());
                }
            }
        } else if (args.length == 3 && args[0].equals("give")) {
            for (EntityType type : EntityType.values()) {
                commands.add(type.toString());
            }
        }
        Collections.sort(commands);
        return commands;
    }

    public String getHash(String input) {
        byte[] messageDigest = input.getBytes();
        BigInteger number = new BigInteger(1, messageDigest);
        String hashtext = number.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext;
    }

    public static Location getLocationString(String s) {
        if (s == null || s.trim() == "") {
            return null;
        }
        String[] parts = s.split(":");
        if (parts.length == 4) {
            World w = Bukkit.getServer().getWorld(parts[0]);
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(w, (double)x, (double)y, (double)z);
        }
        return null;
    }

    public static String getStringLocation(Location l) {
        if (l == null) {
            return "";
        }
        return l.getWorld().getName() + ":" + l.getBlockX() + ":" + l.getBlockY() + ":" + l.getBlockZ();
    }

    public class EmuletedSpawner
    implements Runnable {
        @Override
        public void run() {
            for (Map.Entry entry : StackSpawners.this.spawnerStacks.entrySet()) {
                Location key = StackSpawners.getLocationString((String)entry.getKey());
                BlockState bs = key.getBlock().getState();
                if (!(bs instanceof CreatureSpawner)) continue;
                StackSpawners.this.forcedSpawnerSpawn((CreatureSpawner)bs);
            }
        }
    }
}

