/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.common.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.ultramega.universalgrid.common.ClientUtils;
import com.ultramega.universalgrid.common.gui.view.GridTypes;
import com.ultramega.universalgrid.common.interfaces.MixinGridType;
import com.ultramega.universalgrid.common.interfaces.MixinTabRenderer;
import com.ultramega.universalgrid.common.registry.KeyMappings;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBaseScreen.class})
public abstract class MixinAbstractBaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements MixinTabRenderer {
    @Unique
    private static final ResourceLocation SELECTED_TAB_BOTTOM = ResourceLocation.fromNamespaceAndPath((String)"universalgrid", (String)"selected_tab_bottom");
    @Unique
    private static final ResourceLocation SELECTED_TAB = ResourceLocation.fromNamespaceAndPath((String)"universalgrid", (String)"selected_tab");
    @Unique
    private static final ResourceLocation UNSELECTED_TAB = ResourceLocation.fromNamespaceAndPath((String)"universalgrid", (String)"unselected_tab");
    @Unique
    private static final int TAB_AMOUNT = 3;

    public MixinAbstractBaseScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    @Override
    @Unique
    public void universalgrid$renderGridTabs(GuiGraphics graphics) {
        AbstractBaseContainerMenu containerMenu;
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (abstractContainerMenu instanceof AbstractBaseContainerMenu && ClientUtils.isUniversalGrid(containerMenu = (AbstractBaseContainerMenu)abstractContainerMenu, (Player)Minecraft.getInstance().player)) {
            for (int i = 0; i < 3; ++i) {
                GridTypes gridType = GridTypes.values()[i];
                boolean selected = i == ((MixinGridType)containerMenu).universalgrid$getGridType().ordinal();
                int x = this.universalgrid$getTabX();
                int y = this.universalgrid$getTabY(i);
                PoseStack poseStack = graphics.pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, selected ? 1.0f : 0.0f);
                graphics.blitSprite(selected ? (i == 2 ? SELECTED_TAB_BOTTOM : SELECTED_TAB) : UNSELECTED_TAB, x, y, 32, 26);
                graphics.renderItem(gridType.getIcon(), x + 9, y + 5);
                poseStack.popPose();
            }
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")})
    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, CallbackInfo ci) {
        int hoveringTab = this.universalgrid$getHoveringTab(mouseX, mouseY);
        if (hoveringTab != -1) {
            GridTypes gridType = GridTypes.values()[hoveringTab];
            Platform.INSTANCE.renderTooltip(graphics, List.of(ClientTooltipComponent.create((FormattedCharSequence)gridType.getTooltip().getVisualOrderText())), mouseX, mouseY);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double mouseX, double mouseY, int clickedButton, CallbackInfoReturnable<Boolean> cir) {
        int hoveringTab = this.universalgrid$getHoveringTab(mouseX, mouseY);
        if (hoveringTab != -1) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            GridTypes gridType = GridTypes.values()[hoveringTab];
            ((MixinGridType)this.getMenu()).universalgrid$setGridType(gridType, (Player)Minecraft.getInstance().player);
            cir.setReturnValue((Object)true);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (KeyMappings.INSTANCE.getSwitchWirelessUniversalGridType() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getSwitchWirelessUniversalGridType())) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            GridTypes gridType = GridTypes.getNext(((MixinGridType)this.getMenu()).universalgrid$getGridType());
            ((MixinGridType)this.getMenu()).universalgrid$setGridType(gridType, (Player)Minecraft.getInstance().player);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Unique
    private int universalgrid$getHoveringTab(double mouseX, double mouseY) {
        AbstractBaseContainerMenu containerMenu;
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (abstractContainerMenu instanceof AbstractBaseContainerMenu && ClientUtils.isUniversalGrid(containerMenu = (AbstractBaseContainerMenu)abstractContainerMenu, (Player)Minecraft.getInstance().player)) {
            for (int i = 0; i < 3; ++i) {
                if (!this.isHovering(this.universalgrid$getTabX() - this.leftPos + 3, this.universalgrid$getTabY(i) - this.topPos + 2, 24, 22, mouseX, mouseY)) continue;
                return i;
            }
        }
        return -1;
    }

    @Unique
    private int universalgrid$getTabX() {
        boolean isAutocraftingMonitor = ((MixinGridType)this.getMenu()).universalgrid$getGridType() == GridTypes.WIRELESS_AUTOCRAFTING_MONITOR;
        return this.leftPos + this.imageWidth - (isAutocraftingMonitor ? 4 : 21);
    }

    @Unique
    private int universalgrid$getTabY(int i) {
        return this.topPos + this.imageHeight - 78 + 26 * i;
    }
}

