/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.common.wirelessuniversalgrid;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractNetworkEnergyItem;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.quartzarsenal.common.Items;
import com.ultramega.universalgrid.common.Platform;
import com.ultramega.universalgrid.common.gui.view.GridTypes;
import com.ultramega.universalgrid.common.packet.c2s.UseUniversalGridOnServerPacket;
import com.ultramega.universalgrid.common.packet.s2c.SetCursorPosWindowPacket;
import com.ultramega.universalgrid.common.packet.s2c.UseUniversalGridOnClientPacket;
import com.ultramega.universalgrid.common.registry.DataComponents;
import com.ultramega.universalgrid.common.wirelessuniversalgrid.WirelessUniversalGridState;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class WirelessUniversalGridItem
extends AbstractNetworkEnergyItem {
    private final boolean creative;

    public WirelessUniversalGridItem(boolean creative, EnergyItemHelper energyItemHelper, NetworkItemHelper networkItemHelper) {
        super(new class_1792.class_1793().method_7889(1), energyItemHelper, networkItemHelper);
        this.creative = creative;
    }

    public EnergyStorage createEnergyStorage(class_1799 stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.getConfig().getWirelessUniversalGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asItemEnergyStorage((EnergyStorage)energyStorage, stack);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
        this.useOnClient(level, stack, slotReference);
        return class_1271.method_22428((Object)stack);
    }

    public void use(class_3222 player, class_1799 stack, SlotReference slotReference) {
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (class_8710)new UseUniversalGridOnClientPacket(stack, slotReference));
    }

    protected void use(@Nullable class_2561 name, class_3222 player, SlotReference slotReference, NetworkItemContext context) {
    }

    public void useOnClient(class_1937 level, class_1799 stack, SlotReference slotReference) {
        if (level.method_8608()) {
            GridTypes gridType = Platform.getConfig().getWirelessUniversalGrid().getGridType();
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((class_8710)new UseUniversalGridOnServerPacket(stack, slotReference, gridType));
        }
    }

    public void useGridCorrectly(class_3222 serverPlayer, class_1937 level, SlotReference slotReference, GridTypes gridType) {
        if (level.method_8503() != null) {
            slotReference.resolve((class_1657)serverPlayer).ifPresent(s -> this.openGridType(serverPlayer, (class_1799)s, slotReference, gridType));
        }
    }

    private void openGridType(class_3222 serverPlayer, class_1799 stack, SlotReference slotReference, GridTypes gridType) {
        switch (gridType) {
            case WIRELESS_GRID: {
                com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getWirelessGrid().use(serverPlayer, stack, slotReference);
                break;
            }
            case WIRELESS_CRAFTING_GRID: {
                Items.INSTANCE.getWirelessCraftingGrid().use(serverPlayer, stack, slotReference);
                break;
            }
            case WIRELESS_AUTOCRAFTING_MONITOR: {
                com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getWirelessAutocraftingMonitor().use(serverPlayer, stack, slotReference);
            }
        }
        WirelessUniversalGridState state = (WirelessUniversalGridState)stack.method_57824(DataComponents.INSTANCE.getWirelessUniversalGridState());
        if (state == null) {
            return;
        }
        if (!state.applyCursorPos()) {
            return;
        }
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(serverPlayer, (class_8710)new SetCursorPosWindowPacket(state.cursorX(), state.cursorY()));
        Platform.setWirelessUniversalGridState(stack, state.cursorX(), state.cursorY(), false);
    }
}

