/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="hoyocraft", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue LOG_DIRT_BLOCK = BUILDER.comment("Enable or disable logging for the dirt block.").define("logDirtBlock", true);
    private static final ModConfigSpec.IntValue MAGIC_NUMBER = BUILDER.comment("A magic number for demonstration purposes.").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
    public static final ModConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("The introductory text for the magic number log message.").define("magicNumberIntroduction", (Object)"The magic number is... ");
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of item registry names for demonstration.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
    }
}

