/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.zenith.hoyocraft.Config;
import net.zenith.hoyocraft.ModCreativeModeTabs;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;
import net.zenith.hoyocraft.client.gui.InvasionHudOverlay;
import net.zenith.hoyocraft.command.InvasionCommands;
import net.zenith.hoyocraft.command.ShieldCommands;
import net.zenith.hoyocraft.component.ModDataComponents;
import net.zenith.hoyocraft.config.ServerConfig;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.client.renderer.abyssal.AbyssPortalGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.abyssal.AbyssalPylonGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.finch.FinchGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.hilichurl.HilichurlFighterGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.hilichurl.HilichurlGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.AnemoSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.CryoSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.DendroSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.ElectroSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.GeoSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.HydroSlimeGeoRenderer;
import net.zenith.hoyocraft.entity.client.renderer.slime.PyroSlimeGeoRenderer;
import net.zenith.hoyocraft.event.MobInteractionEvents;
import net.zenith.hoyocraft.invasion.AbyssalInvasionManager;
import net.zenith.hoyocraft.invasion.IncursionPatternManager;
import net.zenith.hoyocraft.item.ModItems;
import org.slf4j.Logger;

@Mod(value="hoyocraft")
public class Hoyocraft {
    public static final String MODID = "hoyocraft";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Hoyocraft(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register(MobInteractionEvents.class);
        NeoForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModDataComponents.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        NeoForge.EVENT_BUS.addListener(this::onAddReloadListener);
    }

    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)IncursionPatternManager.getInstance());
        LOGGER.info("Registered IncursionPatternManager as a reload listener.");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    private void onServerTick(ServerTickEvent.Post event) {
        AbyssalInvasionManager.getInstance().onServerTick(event.getServer().overworld());
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        InvasionCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ShieldCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="hoyocraft", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
            event.registerAbove(VanillaGuiLayers.BOSS_OVERLAY, InvasionHudOverlay.INVASION_HUD_ID, InvasionHudOverlay.HUD_INVASION);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            LOGGER.info("Registering Entity Renderers for hoyocraft");
            event.registerEntityRenderer(ModEntities.HYDRO_SLIME.get(), HydroSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.PYRO_SLIME.get(), PyroSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.ELECTRO_SLIME.get(), ElectroSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.ANEMO_SLIME.get(), AnemoSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.CRYO_SLIME.get(), CryoSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.GEO_SLIME.get(), GeoSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.DENDRO_SLIME.get(), DendroSlimeGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.HILICHURL_FIGHTER.get(), HilichurlFighterGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.HILICHURL.get(), HilichurlGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.ABYSS_PORTAL.get(), AbyssPortalGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.ABYSSAL_PYLON.get(), AbyssalPylonGeoRenderer::new);
            event.registerEntityRenderer(ModEntities.FINCH.get(), FinchGeoRenderer::new);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
        }
    }
}

