/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.api.capability.shield;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinition;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinitions;
import net.zenith.hoyocraft.api.damage.HoyoDamageType;

public class Shield
implements IShield {
    private ShieldDefinition definition = ShieldDefinitions.ABYSSAL;
    private float currentHealth = 0.0f;
    private float maxHealth = 100.0f;
    private float regenRate = 0.0f;
    private int regenCooldown = 0;
    private static final int REGEN_DELAY_ON_HIT = 100;

    @Override
    public ShieldDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(ShieldDefinition definition) {
        this.definition = definition;
    }

    @Override
    public float getCurrentHealth() {
        return this.currentHealth;
    }

    @Override
    public void setCurrentHealth(float health) {
        this.currentHealth = Math.max(0.0f, health);
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    @Override
    public float getRegenRate() {
        return this.regenRate;
    }

    @Override
    public void setRegenRate(float rate) {
        this.regenRate = rate;
    }

    @Override
    public int getRegenCooldown() {
        return this.regenCooldown;
    }

    @Override
    public void setRegenCooldown(int ticks) {
        this.regenCooldown = ticks;
    }

    @Override
    public boolean isActive() {
        return this.currentHealth > 0.0f;
    }

    @Override
    public float takeDamage(float amount, HoyoDamageType damageType) {
        if (!this.isActive()) {
            return amount;
        }
        float multiplier = this.definition.getMultiplierFor(damageType);
        float damageToShield = amount * multiplier;
        float healthBeforeDamage = this.currentHealth;
        this.currentHealth -= damageToShield;
        this.regenCooldown = 100;
        if (this.currentHealth <= 0.0f) {
            this.currentHealth = 0.0f;
            float originalDamageAbsorbed = healthBeforeDamage / multiplier;
            return Math.max(0.0f, amount - originalDamageAbsorbed);
        }
        return 0.0f;
    }

    @Override
    public void tick() {
        if (this.regenCooldown > 0) {
            --this.regenCooldown;
            return;
        }
        if (this.regenRate > 0.0f && this.currentHealth < this.maxHealth) {
            this.currentHealth += this.regenRate / 20.0f;
            if (this.currentHealth > this.maxHealth) {
                this.currentHealth = this.maxHealth;
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.contains("DefinitionID", 8)) {
            ResourceLocation defId = ResourceLocation.parse((String)nbt.getString("DefinitionID"));
            this.definition = ShieldDefinitions.getById(defId).orElse(ShieldDefinitions.ABYSSAL);
        } else {
            this.definition = ShieldDefinitions.ABYSSAL;
        }
        this.maxHealth = nbt.getFloat("MaxHealth");
        this.currentHealth = nbt.getFloat("CurrentHealth");
        this.regenRate = nbt.getFloat("RegenRate");
        this.regenCooldown = nbt.getInt("RegenCooldown");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.definition != null) {
            nbt.putString("DefinitionID", this.definition.id());
        }
        nbt.putFloat("MaxHealth", this.maxHealth);
        nbt.putFloat("CurrentHealth", this.currentHealth);
        nbt.putFloat("RegenRate", this.regenRate);
        nbt.putInt("RegenCooldown", this.regenCooldown);
        return nbt;
    }
}

