/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.api.capability.shield;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinition;
import net.zenith.hoyocraft.api.damage.HoyoDamageType;

public class ShieldDefinitions {
    private static final Map<ResourceLocation, ShieldDefinition> DEFINITIONS_BY_ID = new HashMap<ResourceLocation, ShieldDefinition>();
    public static final ShieldDefinition PYRO = ShieldDefinitions.register("pyro", new ShieldDefinition("hoyocraft:pyro", -48128, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.HYDRO, Float.valueOf(2.5f), HoyoDamageType.CRYO, Float.valueOf(0.5f), HoyoDamageType.PYRO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition HYDRO = ShieldDefinitions.register("hydro", new ShieldDefinition("hoyocraft:hydro", -16742145, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.DENDRO, Float.valueOf(2.0f), HoyoDamageType.PYRO, Float.valueOf(0.5f), HoyoDamageType.HYDRO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition CRYO = ShieldDefinitions.register("cryo", new ShieldDefinition("hoyocraft:cryo", -10040065, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.PYRO, Float.valueOf(2.5f), HoyoDamageType.ELECTRO, Float.valueOf(1.5f), HoyoDamageType.CRYO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition ELECTRO = ShieldDefinitions.register("electro", new ShieldDefinition("hoyocraft:electro", -4508673, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.CRYO, Float.valueOf(1.5f), HoyoDamageType.PYRO, Float.valueOf(1.5f), HoyoDamageType.ELECTRO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition GEO = ShieldDefinitions.register("geo", new ShieldDefinition("hoyocraft:geo", -13261, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.GEO, Float.valueOf(2.0f), HoyoDamageType.PHYSICAL, Float.valueOf(1.5f), HoyoDamageType.GENERIC, Float.valueOf(0.5f))));
    public static final ShieldDefinition DENDRO = ShieldDefinitions.register("dendro", new ShieldDefinition("hoyocraft:dendro", -11150029, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.PYRO, Float.valueOf(2.5f), HoyoDamageType.DENDRO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition ANEMO = ShieldDefinitions.register("anemo", new ShieldDefinition("hoyocraft:anemo", -13378083, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.PYRO, Float.valueOf(1.5f), HoyoDamageType.HYDRO, Float.valueOf(1.5f), HoyoDamageType.CRYO, Float.valueOf(1.5f), HoyoDamageType.ELECTRO, Float.valueOf(1.5f), HoyoDamageType.ANEMO, Float.valueOf(0.1f), HoyoDamageType.GENERIC, Float.valueOf(1.0f))));
    public static final ShieldDefinition ABYSSAL = ShieldDefinitions.register("abyssal", new ShieldDefinition("hoyocraft:abyssal", -1, ShieldDefinition.ShieldBehavior.IMMUNITY, 0.0f, Map.of(HoyoDamageType.GENERIC, Float.valueOf(1.0f))));

    private static ShieldDefinition register(String name, ShieldDefinition definition) {
        DEFINITIONS_BY_ID.put(ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)name), definition);
        return definition;
    }

    public static Optional<ShieldDefinition> getById(ResourceLocation id) {
        return Optional.ofNullable(DEFINITIONS_BY_ID.get(id));
    }

    public static Collection<ResourceLocation> getAllDefinitionIds() {
        return Collections.unmodifiableSet(DEFINITIONS_BY_ID.keySet());
    }
}

