/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.zenith.hoyocraft.block.custom.AbyssalBlock;
import net.zenith.hoyocraft.block.custom.AbyssalDecayBlock;
import net.zenith.hoyocraft.block.custom.AbyssalMudBlock;
import net.zenith.hoyocraft.block.custom.AbyssalNodeBlock;
import net.zenith.hoyocraft.block.custom.AbyssalOozeBlock;
import net.zenith.hoyocraft.block.custom.HilichurlBarrelBlock;
import net.zenith.hoyocraft.block.custom.HilichurlCampfireBlock;
import net.zenith.hoyocraft.block.custom.LargeCrateBlock;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"hoyocraft");
    public static final Supplier<Block> HILICHURL_CAMPFIRE = BLOCKS.register("hilichurl_campfire", () -> new HilichurlCampfireBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(ModBlocks.litBlockEmission(15)).noOcclusion()));
    public static final Supplier<Block> LARGE_CRATE = BLOCKS.register("large_crate", () -> new LargeCrateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.5f).sound(SoundType.WOOD)));
    public static final Supplier<Block> HILICHURL_BARREL = BLOCKS.register("hilichurl_barrel", () -> new HilichurlBarrelBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.5f).sound(SoundType.WOOD)));
    public static final Supplier<Block> ABYSSAL_BLOCK = BLOCKS.register("abyssal_block", () -> new AbyssalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(3.0f, 6.0f).sound(SoundType.STONE).requiresCorrectToolForDrops()));
    public static final Supplier<Block> ABYSSAL_MUD = BLOCKS.register("abyssal_mud", () -> new AbyssalMudBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.2f).sound(SoundType.GRAVEL).noOcclusion()));
    public static final Supplier<Block> ABYSSAL_NODE = BLOCKS.register("abyssal_node", () -> new AbyssalNodeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(4.0f).sound(SoundType.STONE).lightLevel(state -> 8).requiresCorrectToolForDrops()));
    public static final Supplier<Block> ABYSSAL_DECAY_BLOCK = BLOCKS.register("abyssal_decay_block", () -> new AbyssalDecayBlock(BlockBehaviour.Properties.of().noCollission().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> ABYSSAL_OOZE = BLOCKS.register("abyssal_ooze", () -> new AbyssalOozeBlock(BlockBehaviour.Properties.of().sound(SoundType.SLIME_BLOCK).friction(0.8f).strength(0.8f).noOcclusion()));

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? pLightValue : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

