/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;
import net.zenith.hoyocraft.block.entity.custom.AbyssalDecayBlockEntity;
import net.zenith.hoyocraft.block.entity.custom.AbyssalNodeBlockEntity;
import org.jetbrains.annotations.Nullable;

public class AbyssalNodeBlock
extends BaseEntityBlock {
    public static final MapCodec<AbyssalNodeBlock> CODEC = AbyssalNodeBlock.simpleCodec(AbyssalNodeBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public AbyssalNodeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AbyssalNodeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return AbyssalNodeBlock.createTickerHelper(type, ModBlockEntities.ABYSSAL_NODE_BE.get(), AbyssalNodeBlockEntity::serverTick);
        }
        return null;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbyssalNodeBlockEntity) {
            AbyssalNodeBlockEntity nodeEntity = (AbyssalNodeBlockEntity)blockEntity;
            Map<BlockPos, BlockState> corruptedBlocks = nodeEntity.getCorruptedBlocks();
            super.onRemove(state, level, pos, newState, isMoving);
            if (!corruptedBlocks.isEmpty()) {
                level.setBlock(pos, ModBlocks.ABYSSAL_DECAY_BLOCK.get().defaultBlockState(), 3);
                BlockEntity decayEntity = level.getBlockEntity(pos);
                if (decayEntity instanceof AbyssalDecayBlockEntity) {
                    AbyssalDecayBlockEntity decayBlockEntity = (AbyssalDecayBlockEntity)decayEntity;
                    decayBlockEntity.setCorruptionData(corruptedBlocks);
                }
            }
        } else {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

