/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block.custom;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;
import net.zenith.hoyocraft.block.entity.custom.HilichurlCampfireBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HilichurlCampfireBlock
extends CampfireBlock {
    public HilichurlCampfireBlock(BlockBehaviour.Properties properties) {
        super(true, 0, properties);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HilichurlCampfireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pBlockEntityType != ModBlockEntities.HILICHURL_CAMPFIRE_BE.get()) {
            return null;
        }
        if (pLevel.isClientSide()) {
            return (Boolean)pState.getValue((Property)LIT) != false ? HilichurlCampfireBlock.createTickerHelper(pBlockEntityType, ModBlockEntities.HILICHURL_CAMPFIRE_BE.get(), HilichurlCampfireBlockEntity::particleTick) : null;
        }
        return HilichurlCampfireBlock.createTickerHelper(pBlockEntityType, ModBlockEntities.HILICHURL_CAMPFIRE_BE.get(), (level, pos, state, blockEntity) -> {
            if (blockEntity instanceof HilichurlCampfireBlockEntity) {
                HilichurlCampfireBlockEntity hcbe = blockEntity;
                if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                    HilichurlCampfireBlockEntity.cookTick(level, pos, state, hcbe);
                }
                HilichurlCampfireBlockEntity.contributionSpawnerTick(level, pos, state, hcbe);
            }
        });
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide()) {
            HilichurlCampfireBlockEntity hilichurlCampfireBE;
            Optional<RecipeHolder<CampfireCookingRecipe>> optionalRecipe;
            ItemStack itemstack = pPlayer.getItemInHand(pHand);
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof HilichurlCampfireBlockEntity && (optionalRecipe = (hilichurlCampfireBE = (HilichurlCampfireBlockEntity)blockentity).getCookableRecipe(itemstack)).isPresent()) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof HilichurlCampfireBlockEntity) {
            HilichurlCampfireBlockEntity hilichurlCampfireBE = (HilichurlCampfireBlockEntity)blockentity;
            ItemStack itemstack = pPlayer.getItemInHand(pHand);
            Optional<RecipeHolder<CampfireCookingRecipe>> optionalRecipe = hilichurlCampfireBE.getCookableRecipe(itemstack);
            if (optionalRecipe.isPresent()) {
                if (hilichurlCampfireBE.placeFood((LivingEntity)pPlayer, itemstack, ((CampfireCookingRecipe)optionalRecipe.get().value()).getCookingTime())) {
                    pPlayer.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

