/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block.entity.custom;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;

public class AbyssalDecayBlockEntity
extends BlockEntity {
    private Map<BlockPos, BlockState> decayMap = new HashMap<BlockPos, BlockState>();
    private int ticksSinceDecay = 0;
    private static final int DECAY_INTERVAL_TICKS = 1;

    public AbyssalDecayBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ABYSSAL_DECAY_BE.get(), pos, state);
    }

    public void setCorruptionData(Map<BlockPos, BlockState> data) {
        this.decayMap = new HashMap<BlockPos, BlockState>(data);
        this.setChanged();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbyssalDecayBlockEntity be) {
        if (level.isClientSide) {
            return;
        }
        ++be.ticksSinceDecay;
        if (be.ticksSinceDecay < 1) {
            return;
        }
        be.ticksSinceDecay = 0;
        if (be.decayMap.isEmpty()) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        BlockPos furthestPos = be.decayMap.keySet().stream().max(Comparator.comparingDouble(p -> p.distSqr((Vec3i)pos))).orElse(null);
        if (furthestPos != null) {
            BlockState originalState = be.decayMap.get(furthestPos);
            level.setBlockAndUpdate(furthestPos, originalState);
            be.decayMap.remove(furthestPos);
            AbyssalDecayBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag listTag = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.decayMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("pos", NbtUtils.writeBlockPos((BlockPos)entry.getKey()));
            entryTag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)entry.getValue()));
            listTag.add((Object)entryTag);
        }
        tag.put("DecayBlocks", (Tag)listTag);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.decayMap.clear();
        if (tag.contains("DecayBlocks", 9)) {
            ListTag listTag = tag.getList("DecayBlocks", 10);
            HolderLookup.RegistryLookup holderGetter = registries.lookupOrThrow(Registries.BLOCK);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag entryTag = listTag.getCompound(i);
                NbtUtils.readBlockPos((CompoundTag)entryTag, (String)"pos").ifPresent(arg_0 -> this.lambda$loadAdditional$1((HolderGetter)holderGetter, entryTag, arg_0));
            }
        }
    }

    private /* synthetic */ void lambda$loadAdditional$1(HolderGetter holderGetter, CompoundTag entryTag, BlockPos pos) {
        BlockState state = NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)entryTag.getCompound("state"));
        this.decayMap.put(pos, state);
    }
}

