/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.block.custom.AbyssalMudBlock;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;

public class AbyssalNodeBlockEntity
extends BlockEntity {
    private final Map<BlockPos, BlockState> originalStates = new HashMap<BlockPos, BlockState>();
    private static final int MAX_CORRUPTION_RADIUS = 35;
    private static final int SPREAD_INTERVAL = 10;
    private static final int MAX_CORRUPTION_TIME_TICKS = 32000;
    private int corruptionTimer = 32000;
    private int spreadTicker = 0;
    private boolean initialOozePlaced = false;
    private int oozePlaced = 0;
    private static final int OOZE_TO_PLACE = 10;
    private static final int OOZE_PLACE_INTERVAL = 10;
    private int oozePlacerTicker = 0;

    public AbyssalNodeBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ABYSSAL_NODE_BE.get(), pos, state);
    }

    public Map<BlockPos, BlockState> getCorruptedBlocks() {
        return this.originalStates;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbyssalNodeBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.corruptionTimer <= 0) {
            return;
        }
        --blockEntity.corruptionTimer;
        if (!blockEntity.initialOozePlaced) {
            blockEntity.placeInitialOoze(level, pos);
            blockEntity.initialOozePlaced = true;
            AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        blockEntity.handleOozePlacement(level, pos);
        ++blockEntity.spreadTicker;
        if (blockEntity.spreadTicker >= 10) {
            blockEntity.spreadTicker = 0;
            if (level.getRandom().nextInt(3) != 0) {
                blockEntity.spreadAbyssalBlock(level, pos);
            } else {
                blockEntity.spreadAbyssalMud(level, pos);
            }
        }
    }

    private void placeInitialOoze(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.relative(direction);
            BlockState existingState = level.getBlockState(adjacentPos);
            if (!existingState.canBeReplaced()) continue;
            this.originalStates.put(adjacentPos.immutable(), existingState);
            Direction randomDir = Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom());
            level.setBlock(adjacentPos, (BlockState)ModBlocks.ABYSSAL_OOZE.get().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)randomDir), 3);
        }
    }

    private void handleOozePlacement(Level level, BlockPos center) {
        if (this.oozePlaced >= 10) {
            return;
        }
        ++this.oozePlacerTicker;
        if (this.oozePlacerTicker >= 10) {
            this.oozePlacerTicker = 0;
            for (int placementAttempts = 0; placementAttempts < 10; ++placementAttempts) {
                BlockPos targetPos = center.offset(level.getRandom().nextInt(5) - 2, level.getRandom().nextInt(3) - 1, level.getRandom().nextInt(5) - 2);
                BlockState existingState = level.getBlockState(targetPos);
                if (!existingState.isAir() || !ModBlocks.ABYSSAL_OOZE.get().defaultBlockState().canSurvive((LevelReader)level, targetPos)) continue;
                this.originalStates.put(targetPos.immutable(), existingState);
                Direction randomDir = Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom());
                level.setBlock(targetPos, (BlockState)ModBlocks.ABYSSAL_OOZE.get().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)randomDir), 3);
                ++this.oozePlaced;
                AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)center, (BlockState)this.getBlockState());
                break;
            }
        }
    }

    private void spreadAbyssalBlock(Level level, BlockPos pos) {
        ArrayList<BlockPos> infected = new ArrayList<BlockPos>(this.originalStates.keySet());
        if (infected.isEmpty()) {
            BlockPos startPos = pos.below();
            BlockState startState = level.getBlockState(startPos);
            if (AbyssalNodeBlockEntity.isCorruptible(startState)) {
                this.originalStates.put(startPos.immutable(), startState);
                level.setBlock(startPos, ModBlocks.ABYSSAL_BLOCK.get().defaultBlockState(), 3);
                AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)this.getBlockState());
            }
            return;
        }
        Collections.shuffle(infected);
        for (BlockPos corruptedPos : infected) {
            int attempts = 10;
            for (int i = 0; i < attempts; ++i) {
                BlockState neighborState;
                BlockPos neighborPos;
                if (level.getRandom().nextFloat() < 0.75f) {
                    int dX = level.getRandom().nextInt(3) - 1;
                    int dZ = level.getRandom().nextInt(3) - 1;
                    neighborPos = corruptedPos.offset(dX, 0, dZ);
                } else {
                    neighborPos = corruptedPos.offset(level.getRandom().nextInt(3) - 1, level.getRandom().nextInt(3) - 1, level.getRandom().nextInt(3) - 1);
                }
                if (neighborPos.equals((Object)corruptedPos) || !(neighborPos.distSqr((Vec3i)pos) <= 1225.0) || this.originalStates.containsKey(neighborPos) || !AbyssalNodeBlockEntity.isCorruptible(neighborState = level.getBlockState(neighborPos))) continue;
                this.originalStates.put(neighborPos.immutable(), neighborState);
                level.setBlock(neighborPos, ModBlocks.ABYSSAL_BLOCK.get().defaultBlockState(), 3);
                AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)this.getBlockState());
                return;
            }
        }
    }

    private void spreadAbyssalMud(Level level, BlockPos pos) {
        ArrayList<BlockPos> infected = new ArrayList<BlockPos>(this.originalStates.keySet());
        if (infected.isEmpty()) {
            return;
        }
        Collections.shuffle(infected);
        for (BlockPos corruptedPos : infected) {
            int attempts = 10;
            for (int i = 0; i < attempts; ++i) {
                BlockPos neighborPos = corruptedPos.offset(level.getRandom().nextInt(3) - 1, level.getRandom().nextInt(3) - 1, level.getRandom().nextInt(3) - 1);
                if (neighborPos.equals((Object)corruptedPos) || neighborPos.distSqr((Vec3i)pos) > 1225.0) continue;
                BlockState neighborState = level.getBlockState(neighborPos);
                if (neighborState.is(ModBlocks.ABYSSAL_MUD.get())) {
                    int layers = (Integer)neighborState.getValue((Property)AbyssalMudBlock.LAYERS);
                    if (layers >= 8) continue;
                    Direction randomDir = Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom());
                    level.setBlock(neighborPos, (BlockState)((BlockState)neighborState.setValue((Property)AbyssalMudBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)randomDir), 3);
                    AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)this.getBlockState());
                    return;
                }
                if (!neighborState.canBeReplaced() || !ModBlocks.ABYSSAL_MUD.get().defaultBlockState().canSurvive((LevelReader)level, neighborPos)) continue;
                if (!this.originalStates.containsKey(neighborPos)) {
                    this.originalStates.put(neighborPos.immutable(), neighborState);
                }
                Direction randomDir = Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom());
                level.setBlock(neighborPos, (BlockState)ModBlocks.ABYSSAL_MUD.get().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)randomDir), 3);
                AbyssalNodeBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)this.getBlockState());
                return;
            }
        }
    }

    private void spreadCorruption(Level level, BlockPos pos) {
    }

    private static boolean isCorruptible(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.GRASS_BLOCK || block == Blocks.DIRT || block == Blocks.STONE || block == Blocks.SAND || block == Blocks.GRAVEL || block == Blocks.ANDESITE || block == Blocks.DIORITE || block == Blocks.GRANITE || block == Blocks.DEEPSLATE;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        ListTag corruptedBlocksTag = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.originalStates.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("pos", NbtUtils.writeBlockPos((BlockPos)entry.getKey()));
            entryTag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)entry.getValue()));
            corruptedBlocksTag.add((Object)entryTag);
        }
        nbt.put("CorruptedBlocks", (Tag)corruptedBlocksTag);
        nbt.putInt("OozePlaced", this.oozePlaced);
        nbt.putBoolean("InitialOozePlaced", this.initialOozePlaced);
        nbt.putInt("CorruptionTimer", this.corruptionTimer);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.originalStates.clear();
        ListTag corruptedBlocksTag = nbt.getList("CorruptedBlocks", 10);
        HolderLookup.RegistryLookup holderGetter = registries.lookupOrThrow(Registries.BLOCK);
        for (int i = 0; i < corruptedBlocksTag.size(); ++i) {
            CompoundTag entryTag = corruptedBlocksTag.getCompound(i);
            NbtUtils.readBlockPos((CompoundTag)entryTag, (String)"pos").ifPresent(arg_0 -> this.lambda$loadAdditional$0((HolderGetter)holderGetter, entryTag, arg_0));
        }
        this.oozePlaced = nbt.getInt("OozePlaced");
        this.initialOozePlaced = nbt.getBoolean("InitialOozePlaced");
        this.corruptionTimer = nbt.contains("CorruptionTimer", 3) ? nbt.getInt("CorruptionTimer") : 32000;
    }

    private /* synthetic */ void lambda$loadAdditional$0(HolderGetter holderGetter, CompoundTag entryTag, BlockPos pos) {
        BlockState state = NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)entryTag.getCompound("state"));
        this.originalStates.put(pos, state);
    }
}

