/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.block.entity.custom;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;
import net.zenith.hoyocraft.worldgen.camp.CampContributionPlacer;
import net.zenith.hoyocraft.worldgen.camp.CampContributionType;

public class HilichurlCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
    private static final int MAX_CONTRIBUTIONS_CAP = 15;
    private int contributionsSuccessfullySpawned = 0;
    private int contributionAttemptCooldown = 0;
    private static final int BASE_CONTRIBUTION_COOLDOWN_TICKS = 100;
    private static final int RANDOM_CONTRIBUTION_COOLDOWN_TICKS = 50;

    private void attemptToSpawnOneContribution(ServerLevel serverLevel, BlockPos campFirePos, RandomSource random) {
        if (this.contributionsSuccessfullySpawned >= 15) {
            return;
        }
        ArrayList<Pair> weightedContributionTypes = new ArrayList<Pair>();
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.HAY_BALE), (Object)5.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.LEASHED_ANIMAL), (Object)5.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.LOG_PILE), (Object)4.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.LARGE_CRATE), (Object)7.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.HILICHURL_BARREL), (Object)7.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.FENCE_STRAIGHT), (Object)6.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.FENCE_L_SHAPE), (Object)7.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.FENCE_U_SHAPE), (Object)6.0));
        weightedContributionTypes.add(Pair.of((Object)((Object)CampContributionType.FENCE_ZIG_ZAG), (Object)5.0));
        double totalWeight = 0.0;
        for (Pair pair : weightedContributionTypes) {
            totalWeight += ((Double)pair.getSecond()).doubleValue();
        }
        if (totalWeight <= 0.0) {
            return;
        }
        double r = random.nextDouble() * totalWeight;
        Enum selectedType = null;
        for (Pair pair : weightedContributionTypes) {
            if (!((r -= ((Double)pair.getSecond()).doubleValue()) <= 0.0)) continue;
            selectedType = (CampContributionType)((Object)pair.getFirst());
            break;
        }
        if (selectedType == null) {
            selectedType = (CampContributionType)((Object)((Pair)weightedContributionTypes.get(random.nextInt(weightedContributionTypes.size()))).getFirst());
        }
        boolean placedSuccessfully = false;
        switch (1.$SwitchMap$net$zenith$hoyocraft$worldgen$camp$CampContributionType[selectedType.ordinal()]) {
            case 1: {
                placedSuccessfully = CampContributionPlacer.tryPlaceHayBale(serverLevel, campFirePos, random);
                break;
            }
            case 2: {
                placedSuccessfully = CampContributionPlacer.trySpawnLeashedAnimal(serverLevel, campFirePos, random);
                break;
            }
            case 3: {
                placedSuccessfully = CampContributionPlacer.tryPlaceLogPile(serverLevel, campFirePos, random);
                break;
            }
            case 4: {
                placedSuccessfully = CampContributionPlacer.tryPlaceLargeCrate(serverLevel, campFirePos, random);
                break;
            }
            case 5: {
                placedSuccessfully = CampContributionPlacer.tryPlaceHilichurlBarrel(serverLevel, campFirePos, random);
                break;
            }
            case 6: {
                placedSuccessfully = CampContributionPlacer.tryPlaceFence(serverLevel, campFirePos, random, CampContributionPlacer.FenceShape.STRAIGHT);
                break;
            }
            case 7: {
                placedSuccessfully = CampContributionPlacer.tryPlaceFence(serverLevel, campFirePos, random, CampContributionPlacer.FenceShape.L_SHAPE);
                break;
            }
            case 8: {
                placedSuccessfully = CampContributionPlacer.tryPlaceFence(serverLevel, campFirePos, random, CampContributionPlacer.FenceShape.U_SHAPE);
                break;
            }
            case 9: {
                placedSuccessfully = CampContributionPlacer.tryPlaceFence(serverLevel, campFirePos, random, CampContributionPlacer.FenceShape.ZIG_ZAG);
            }
        }
        if (placedSuccessfully) {
            ++this.contributionsSuccessfullySpawned;
            this.setChanged();
        }
    }

    public HilichurlCampfireBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.HILICHURL_CAMPFIRE_BE.get(), pPos, pBlockState);
    }

    public static void cookTick(Level pLevel, BlockPos pPos, BlockState pState, HilichurlCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)pBlockEntity.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            pBlockEntity.cookingProgress[n] = pBlockEntity.cookingProgress[n] + 1;
            if (pBlockEntity.cookingProgress[i] < pBlockEntity.cookingTime[i] || !(itemstack1 = pBlockEntity.quickCheck.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), pLevel).map(recipeHolder -> ((CampfireCookingRecipe)recipeHolder.value()).assemble(singlerecipeinput, (HolderLookup.Provider)pLevel.registryAccess())).orElse(itemstack)).isItemEnabled(pLevel.enabledFeatures())) continue;
            Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)itemstack1);
            pBlockEntity.items.set(i, (Object)ItemStack.EMPTY);
            pLevel.sendBlockUpdated(pPos, pState, pState, 3);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)pState));
        }
        if (flag) {
            HilichurlCampfireBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void particleTick(Level pLevel, BlockPos pPos, BlockState pState, HilichurlCampfireBlockEntity pBlockEntity) {
        RandomSource randomsource = pLevel.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles((Level)pLevel, (BlockPos)pPos, (boolean)((Boolean)pState.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
            }
        }
        int l = ((Direction)pState.getValue((Property)CampfireBlock.FACING)).get2DDataValue();
        for (int j = 0; j < pBlockEntity.items.size(); ++j) {
            if (((ItemStack)pBlockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + l, 4));
            double d0 = (double)pPos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pPos.getY() + 0.5;
            double d2 = (double)pPos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public static void contributionSpawnerTick(Level pLevel, BlockPos pPos, BlockState pState, HilichurlCampfireBlockEntity pBlockEntity) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (pBlockEntity.contributionAttemptCooldown > 0) {
            --pBlockEntity.contributionAttemptCooldown;
        } else {
            pBlockEntity.contributionAttemptCooldown = 100 + pLevel.getRandom().nextInt(51);
            if (pBlockEntity.contributionsSuccessfullySpawned < 15) {
                pBlockEntity.attemptToSpawnOneContribution((ServerLevel)pLevel, pPos, pLevel.getRandom());
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        if (pTag.contains("CookingTimes", 11)) {
            int[] aint = pTag.getIntArray("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (pTag.contains("CookingTotalTimes", 11)) {
            int[] aint1 = pTag.getIntArray("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
        this.contributionsSuccessfullySpawned = pTag.getInt("ContributionsSpawned");
        if (pTag.contains("ContributionAttemptCooldown")) {
            this.contributionAttemptCooldown = pTag.getInt("ContributionAttemptCooldown");
        } else if (this.level != null && !this.level.isClientSide()) {
            this.contributionAttemptCooldown = 100 + this.level.getRandom().nextInt(51);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (boolean)true, (HolderLookup.Provider)pRegistries);
        pTag.putIntArray("CookingTimes", this.cookingProgress);
        pTag.putIntArray("CookingTotalTimes", this.cookingTime);
        pTag.putInt("ContributionsSpawned", this.contributionsSuccessfullySpawned);
        pTag.putInt("ContributionAttemptCooldown", this.contributionAttemptCooldown);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, pRegistries);
        return compoundtag;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getCookableRecipe(ItemStack pStack) {
        return this.items.stream().noneMatch(ItemStack::isEmpty) ? Optional.empty() : this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(pStack), this.level);
    }

    public boolean placeFood(@Nullable LivingEntity pEntity, ItemStack pStack, int pCookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.cookingTime[i] = pCookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)pStack.consumeAndReturn(1, pEntity));
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)pEntity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void clearContent() {
        this.items.clear();
        this.markUpdated();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ItemContainerContents)pComponentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }
}

