/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;

public class ClientInvasionState {
    private static boolean invasionActive = false;
    private static int activePortals = 0;
    private static int totalPortals = 0;
    private static int clientKnownPortalsSpawned = 0;
    private static final int INTRO_FRAME_DURATION_TICKS = 2;
    private static final int INTRO_TOTAL_ANIMATION_FRAMES = 5;
    private static final int PORTAL_SPAWN_ANIM_DURATION_TICKS = 12;
    private static final int PORTAL_WAVECLEAR_ANIM_DURATION_TICKS = 12;
    private static final Map<Integer, Long> portalSpawnAnimTimes = new ConcurrentHashMap<Integer, Long>();
    private static final Map<Integer, Long> waveClearPulseTimes = new ConcurrentHashMap<Integer, Long>();
    private static final Map<Integer, Long> portalIntroAnimTimes = new ConcurrentHashMap<Integer, Long>();

    public static boolean isInvasionActive() {
        return invasionActive;
    }

    public static void setInvasionActive(boolean active) {
        if (invasionActive != active) {
            invasionActive = active;
            if (!active) {
                portalSpawnAnimTimes.clear();
                waveClearPulseTimes.clear();
                portalIntroAnimTimes.clear();
                clientKnownPortalsSpawned = 0;
                activePortals = 0;
                totalPortals = 0;
            }
        }
    }

    public static void setActivePortals(int newActivePortals) {
        activePortals = newActivePortals;
    }

    public static void setPortalsEverSpawned(int newPortalsEverSpawned) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        if (newPortalsEverSpawned > clientKnownPortalsSpawned) {
            for (int i = clientKnownPortalsSpawned; i < newPortalsEverSpawned; ++i) {
                if (portalIntroAnimTimes.containsKey(i)) continue;
                portalIntroAnimTimes.put(i, mc.level.getGameTime());
            }
        }
        clientKnownPortalsSpawned = newPortalsEverSpawned;
    }

    public static int getPortalsEverSpawned() {
        return clientKnownPortalsSpawned;
    }

    public static boolean isPortalInIntroAnim(int portalIndex) {
        Long startTime = portalIntroAnimTimes.get(portalIndex);
        if (startTime == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return false;
        }
        return mc.level.getGameTime() - startTime < 10L;
    }

    public static long getPortalIntroAnimStartTime(int portalIndex) {
        return portalIntroAnimTimes.getOrDefault(portalIndex, -1L);
    }

    public static void setTotalPortals(int newTotalPortals) {
        totalPortals = newTotalPortals;
    }

    public static int getActivePortals() {
        return activePortals;
    }

    public static int getTotalPortals() {
        return totalPortals;
    }

    public static void triggerPortalSpawnAnim(int portalIndex) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            portalSpawnAnimTimes.put(portalIndex, mc.level.getGameTime());
        }
    }

    public static boolean isPortalInSpawnAnim(int portalIndex) {
        Long startTime = portalSpawnAnimTimes.get(portalIndex);
        if (startTime == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return false;
        }
        if (mc.level.getGameTime() - startTime < 12L) {
            return true;
        }
        portalSpawnAnimTimes.remove(portalIndex);
        return false;
    }

    public static long getPortalSpawnAnimStartTime(int portalIndex) {
        return portalSpawnAnimTimes.getOrDefault(portalIndex, -1L);
    }

    public static void triggerWaveClearPulse(int portalIndex) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            waveClearPulseTimes.put(portalIndex, mc.level.getGameTime());
        }
    }

    public static long getLastWaveClearPulseTime(int portalIndex) {
        return waveClearPulseTimes.getOrDefault(portalIndex, -1L);
    }

    public static boolean isWaveClearPulseActive(int portalIndex) {
        Long startTime = waveClearPulseTimes.get(portalIndex);
        if (startTime == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return false;
        }
        if (mc.level.getGameTime() - startTime < 12L) {
            return true;
        }
        waveClearPulseTimes.remove(portalIndex);
        return false;
    }
}

