/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.client;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.block.entity.ModBlockEntities;
import net.zenith.hoyocraft.client.renderer.blockentity.HilichurlCampfireRenderer;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.client.renderer.slime.PyroSlimeGeoRenderer;

@EventBusSubscriber(modid="hoyocraft", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.HILICHURL_CAMPFIRE.get(), (RenderType)RenderType.cutout());
                System.out.println("hoyocraft: Set render layer for Hilichurl Campfire to cutout.");
            }
            catch (Exception e) {
                System.err.println("hoyocraft: Failed to set render layer for Hilichurl Campfire: " + e.getMessage());
                e.printStackTrace();
            }
            try {
                BlockEntityRenderers.register(ModBlockEntities.HILICHURL_CAMPFIRE_BE.get(), HilichurlCampfireRenderer::new);
                System.out.println("hoyocraft: Registered HilichurlCampfireRenderer for HilichurlCampfireBlockEntity.");
            }
            catch (Exception e) {
                System.err.println("hoyocraft: Failed to register BE renderer for Hilichurl Campfire: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntities.PYRO_SLIME.get(), PyroSlimeGeoRenderer::new);
    }
}

