/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.zenith.hoyocraft.client.ClientInvasionState;

public class InvasionHudOverlay {
    public static final ResourceLocation INVASION_HUD_ID = ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"invasion_hud");
    private static final ResourceLocation[] EDGE_FRAMES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_edge6.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_edge5.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_edge4.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_edge3.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_edge2.png")};
    private static final int[] EDGE_DIMENSIONS = new int[]{40, 36, 32, 28, 24};
    private static final ResourceLocation PORTAL_ICON_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active.png");
    private static final ResourceLocation PORTAL_ICON_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_inactive.png");
    private static final ResourceLocation[] PORTAL_ICON_SPAWNING_FRAMES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon1.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon2.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon3.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon4.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon5.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_summon6.png")};
    private static final ResourceLocation[] PORTAL_ICON_WAVECLEAR_FRAMES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear1.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear2.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear3.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear4.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear5.png"), ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/portal_icon_active_waveclear6.png")};
    private static final int INTRO_FRAME_DURATION_TICKS = 2;
    private static final int INTRO_TOTAL_ANIMATION_FRAMES = EDGE_FRAMES.length;
    private static final int IDLE_CYCLE_DURATION_TICKS = 100;
    private static final int IDLE_HOP_DURATION_TICKS = 10;
    private static final int IDLE_HOP_HEIGHT = 3;
    private static final int SPAWN_ANIM_FRAME_DURATION = 2;
    private static final int SPAWN_ANIM_TOTAL_FRAMES = 6;
    private static final int WAVECLEAR_ANIM_FRAME_DURATION = 2;
    private static final int WAVECLEAR_ANIM_TOTAL_FRAMES = 6;
    private static final int FINAL_ICON_SIZE = 20;
    private static final int WAVECLEAR_ICON_SIZE = 32;
    private static final int ICON_SPACING = 2;
    public static final LayeredDraw.Layer HUD_INVASION = (graphics, partialTick) -> {
        if (!ClientInvasionState.isInvasionActive()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        int activePortals = ClientInvasionState.getActivePortals();
        int portalsEverSpawned = ClientInvasionState.getPortalsEverSpawned();
        if (portalsEverSpawned <= 0) {
            return;
        }
        int startX = 10;
        int baseY = 10;
        for (int i = 0; i < portalsEverSpawned; ++i) {
            ResourceLocation iconToDraw;
            boolean isPortalAlive;
            boolean bl = isPortalAlive = i < activePortals;
            if (!isPortalAlive) {
                float xPos = 10 + i * 22;
                graphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                graphics.blit(PORTAL_ICON_INACTIVE, (int)xPos, 10, 0.0f, 0.0f, 20, 20, 20, 20);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                continue;
            }
            if (ClientInvasionState.isPortalInIntroAnim(i)) {
                long introStartTime = ClientInvasionState.getPortalIntroAnimStartTime(i);
                long elapsedIntroTicks = mc.level.getGameTime() - introStartTime;
                int introFrameIndex = (int)(elapsedIntroTicks / 2L);
                introFrameIndex = Math.min(introFrameIndex, INTRO_TOTAL_ANIMATION_FRAMES - 1);
                int currentEdgeSize = EDGE_DIMENSIONS[introFrameIndex];
                float iconCenterX = (float)(10 + i * 22) + 10.0f;
                float iconCenterY = 20.0f;
                int x = (int)(iconCenterX - (float)currentEdgeSize / 2.0f);
                int y = (int)(iconCenterY - (float)currentEdgeSize / 2.0f);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.blit(EDGE_FRAMES[introFrameIndex], x, y, 0.0f, 0.0f, currentEdgeSize, currentEdgeSize, currentEdgeSize, currentEdgeSize);
                continue;
            }
            int yOffset = 0;
            long timeInCycle = (mc.level.getGameTime() + (long)(i * 15)) % 100L;
            if (timeInCycle < 10L) {
                float hopProgress = (float)timeInCycle / 10.0f;
                yOffset = (int)(Math.sin((double)hopProgress * Math.PI) * 3.0);
            }
            int iconSize = 20;
            float xPos = 10 + i * 22;
            float yPos = 10 - yOffset;
            boolean isSpawning = ClientInvasionState.isPortalInSpawnAnim(i);
            boolean isWaveClearing = ClientInvasionState.isWaveClearPulseActive(i);
            if (isSpawning) {
                long spawnAnimStartTime = ClientInvasionState.getPortalSpawnAnimStartTime(i);
                long elapsedSpawnTicks = mc.level.getGameTime() - spawnAnimStartTime;
                int spawnFrameIndex = (int)(elapsedSpawnTicks / 2L);
                iconToDraw = PORTAL_ICON_SPAWNING_FRAMES[Math.min(spawnFrameIndex, 5)];
            } else if (isWaveClearing) {
                iconSize = 32;
                long waveClearStartTime = ClientInvasionState.getLastWaveClearPulseTime(i);
                long elapsedWaveClearTicks = mc.level.getGameTime() - waveClearStartTime;
                int waveClearFrameIndex = (int)(elapsedWaveClearTicks / 2L);
                iconToDraw = PORTAL_ICON_WAVECLEAR_FRAMES[Math.min(waveClearFrameIndex, 5)];
                float sizeDiff = 12.0f;
                xPos -= sizeDiff / 2.0f;
                yPos -= sizeDiff / 2.0f;
            } else {
                iconToDraw = PORTAL_ICON_ACTIVE;
            }
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.blit(iconToDraw, (int)xPos, (int)yPos, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
    };
}

