/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.capability.ShieldCapability;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ShieldBarRenderLayer<T extends GenshinEntity, M extends GeoModel<T>>
extends GeoRenderLayer<T> {
    private static final float BAR_WIDTH = 1.0f;
    private static final float BAR_HEIGHT = 0.1f;
    private static final float RENDER_SCALE = 0.5f;
    private static final float VERTICAL_OFFSET = 0.25f;
    private static final float HORIZONTAL_OFFSET = 0.0f;
    private static final float Z_OFFSET = 0.1f;
    private static final float Z_SEPARATION = 0.005f;
    private static final int BG_COLOR = -1775095246;
    private static final RenderType SHIELD_BAR_RENDER_TYPE = RenderType.lightning();

    public ShieldBarRenderLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    public void render(PoseStack poseStack, T entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        IShield shield = (IShield)entity.getCapability(ShieldCapability.SHIELD_CAPABILITY);
        if (shield == null || !shield.isActive()) {
            return;
        }
        GeoBone overlayBone = bakedModel.getBone("overlay").orElse(null);
        if (overlayBone != null) {
            poseStack.pushPose();
            poseStack.mulPose(overlayBone.getModelSpaceMatrix());
            poseStack.translate(0.0f, 0.25f, 0.0f);
            float cameraYRot = Minecraft.getInstance().getEntityRenderDispatcher().camera.getYRot();
            float cameraXRot = Minecraft.getInstance().getEntityRenderDispatcher().camera.getXRot();
            poseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -cameraYRot));
            poseStack.mulPose(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, cameraXRot));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Matrix4f modelViewMatrix = poseStack.last().pose();
            Matrix3f normalMatrix = poseStack.last().normal();
            VertexConsumer barBuffer = bufferSource.getBuffer(SHIELD_BAR_RENDER_TYPE);
            float shieldPercentage = 0.0f;
            if (shield.getMaxHealth() > 0.0f) {
                shieldPercentage = shield.getCurrentHealth() / shield.getMaxHealth();
            }
            shieldPercentage = Math.max(0.0f, Math.min(1.0f, shieldPercentage));
            float currentBarWidth = 1.0f * shieldPercentage;
            float bgX1 = -0.5f;
            float bgX2 = 0.5f;
            float bgY1 = -0.05f;
            float bgY2 = 0.05f;
            Vector3f normal = normalMatrix.transform(new Vector3f(0.0f, 0.0f, 1.0f));
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, bgX1, bgY1, 0.1f, -1775095246, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, bgX1, bgY2, 0.1f, -1775095246, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, bgX2, bgY2, 0.1f, -1775095246, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, bgX2, bgY1, 0.1f, -1775095246, packedLight, packedOverlay);
            float fgX1 = -0.5f;
            float fgX2 = -0.5f + currentBarWidth;
            float fgY1 = -0.05f;
            float fgY2 = 0.05f;
            int fgColor = shield.getDefinition().color();
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, fgX1, fgY1, 0.105000004f, fgColor, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, fgX1, fgY2, 0.105000004f, fgColor, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, fgX2, fgY2, 0.105000004f, fgColor, packedLight, packedOverlay);
            this.addQuadVertex(barBuffer, modelViewMatrix, normal, fgX2, fgY1, 0.105000004f, fgColor, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    private void addQuadVertex(VertexConsumer consumer, Matrix4f modelViewMatrix, Vector3f normal, float x, float y, float z, int color, int packedLight, int packedOverlay) {
        Vector3f pos = modelViewMatrix.transformPosition(new Vector3f(x, y, z));
        consumer.addVertex(pos.x(), pos.y(), pos.z()).setColor(color).setUv(0.0f, 0.0f).setOverlay(packedOverlay).setLight(packedLight).setNormal(normal.x(), normal.y(), normal.z());
    }
}

