/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.zenith.hoyocraft.invasion.AbyssalInvasionManager;

public class InvasionCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hoyo").then(((LiteralArgumentBuilder)Commands.literal((String)"startinvasion").requires(source -> source.hasPermission(2))).executes(InvasionCommands::startInvasion))).then(((LiteralArgumentBuilder)Commands.literal((String)"stopinvasion").requires(source -> source.hasPermission(2))).executes(InvasionCommands::stopInvasion))).then(((LiteralArgumentBuilder)Commands.literal((String)"resetinvasion").requires(source -> source.hasPermission(2))).executes(InvasionCommands::resetInvasion))).then(((LiteralArgumentBuilder)Commands.literal((String)"nextday").requires(source -> source.hasPermission(2))).executes(InvasionCommands::nextDay)));
    }

    private static int startInvasion(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        boolean success = AbyssalInvasionManager.getInstance().startIncursion(level, ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"day_5_default"));
        if (success) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Abyssal Incursion manually started."), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Failed to start incursion. See console for details."));
        }
        return 1;
    }

    private static int stopInvasion(CommandContext<CommandSourceStack> context) {
        AbyssalInvasionManager.getInstance().forceStopAllIncursions(((CommandSourceStack)context.getSource()).getLevel());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"All active Abyssal Incursions have been stopped."), true);
        return 1;
    }

    private static int nextDay(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        long currentTime = level.getDayTime();
        long remainingTime = 24000L - currentTime % 24000L;
        level.getServer().getLevel(level.dimension()).setDayTime(currentTime + remainingTime);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Advanced to the next day."), true);
        return 1;
    }

    private static int resetInvasion(CommandContext<CommandSourceStack> context) {
        AbyssalInvasionManager.getInstance().resetInvasionSystem(((CommandSourceStack)context.getSource()).getLevel());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Abyssal Incursion system has been reset."), true);
        return 1;
    }
}

