/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinition;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinitions;
import net.zenith.hoyocraft.capability.ShieldCapability;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class ShieldCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"hoyo").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shield").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(ShieldDefinitions.getAllDefinitionIds().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> ShieldCommands.executeGiveShield((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"health"), 0.0f))).then(Commands.argument((String)"regen", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> ShieldCommands.executeGiveShield((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"health"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"regen"))))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(ShieldCommands::executeRemoveShield)))));
    }

    private static int executeGiveShield(CommandContext<CommandSourceStack> context, float health, float regen) throws CommandSyntaxException {
        float finalHealth = health;
        float finalRegen = regen;
        Collection targets = EntityArgument.getEntities(context, (String)"targets");
        ResourceLocation shieldTypeId = ResourceLocationArgument.getId(context, (String)"type");
        ShieldDefinition definition = ShieldDefinitions.getById(shieldTypeId).orElseThrow(() -> new CommandSyntaxException(null, (Message)Component.literal((String)("Unknown shield type: " + String.valueOf(shieldTypeId)))));
        int entitiesAffected = 0;
        for (Entity entity : targets) {
            IShield shield;
            if (!(entity instanceof GenshinEntity) || (shield = (IShield)entity.getCapability(ShieldCapability.SHIELD_CAPABILITY)) == null) continue;
            shield.setDefinition(definition);
            shield.setMaxHealth(finalHealth);
            shield.setCurrentHealth(finalHealth);
            shield.setRegenRate(finalRegen);
            shield.setRegenCooldown(0);
            ++entitiesAffected;
        }
        int finalEntitiesAffected = entitiesAffected;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Gave shield '" + String.valueOf(shieldTypeId) + "' to " + finalEntitiesAffected + " entities.")), true);
        return entitiesAffected;
    }

    private static int executeRemoveShield(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getEntities(context, (String)"targets");
        int entitiesAffected = 0;
        for (Entity entity : targets) {
            IShield shield;
            if (!(entity instanceof GenshinEntity) || (shield = (IShield)entity.getCapability(ShieldCapability.SHIELD_CAPABILITY)) == null) continue;
            shield.setCurrentHealth(0.0f);
            ++entitiesAffected;
        }
        int finalEntitiesAffected = entitiesAffected;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed shields from " + finalEntitiesAffected + " entities.")), true);
        return entitiesAffected;
    }
}

