/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue INVASION_INTERVAL_DAYS;
    public static final ModConfigSpec.IntValue DAY5_PORTAL_COUNT;
    public static final ModConfigSpec.IntValue DAY5_NODE_COUNT;
    public static final ModConfigSpec.IntValue DAY5_SPAWN_RADIUS;
    public static final ModConfigSpec.IntValue DAY5_WAVE_COUNT;
    public static final ModConfigSpec.IntValue DAY5_WAVE_INTERVAL_TICKS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> DAY5_WAVE_1_SPAWNS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> DAY5_WAVE_2_SPAWNS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> DAY5_WAVE_3_SPAWNS;
    public static final ModConfigSpec SPEC;

    static {
        BUILDER.push("Abyssal Invasion");
        INVASION_INTERVAL_DAYS = BUILDER.comment("The number of in-game days between automatic Abyssal Invasions.").defineInRange("invasionIntervalDays", 5, 1, 365);
        BUILDER.push("Day 5 Invasion");
        DAY5_PORTAL_COUNT = BUILDER.comment("The number of portals to spawn during the Day 5 invasion.").defineInRange("day5PortalCount", 1, 0, 10);
        DAY5_NODE_COUNT = BUILDER.comment("The number of Abyssal Nodes to spawn during the Day 5 invasion.").defineInRange("day5NodeCount", 0, 0, 20);
        DAY5_SPAWN_RADIUS = BUILDER.comment("The maximum radius from the player where portals and nodes can spawn for the Day 5 invasion.").defineInRange("day5SpawnRadius", 120, 30, 1000);
        BUILDER.push("Wave Settings");
        DAY5_WAVE_COUNT = BUILDER.comment("The total number of waves for the Day 5 invasion.").defineInRange("day5WaveCount", 3, 1, 20);
        DAY5_WAVE_INTERVAL_TICKS = BUILDER.comment("The time in ticks between each wave of the Day 5 invasion.").defineInRange("day5WaveIntervalTicks", 1200, 20, 72000);
        DAY5_WAVE_1_SPAWNS = BUILDER.comment("Spawns for wave 1 of the Day 5 invasion. Format: 'modid:entity,min_count,max_count'").defineList("day5Wave1Spawns", List.of("hoyocraft:hilichurl,1,2", "hoyocraft:hilichurl_fighter,2,3"), s -> s instanceof String);
        DAY5_WAVE_2_SPAWNS = BUILDER.comment("Spawns for wave 2 of the Day 5 invasion.").defineList("day5Wave2Spawns", List.of("hoyocraft:hilichurl,2,2", "hoyocraft:hilichurl_fighter,3,4"), s -> s instanceof String);
        DAY5_WAVE_3_SPAWNS = BUILDER.comment("Spawns for wave 3 of the Day 5 invasion.").defineList("day5Wave3Spawns", List.of("hoyocraft:hilichurl,2,3", "hoyocraft:hilichurl_fighter,4,5"), s -> s instanceof String);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

