/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlFighterEntity;

@EventBusSubscriber(modid="hoyocraft")
public class SpawnTestCommand {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"testspawn").requires(source -> source.hasPermission(2))).executes(SpawnTestCommand::executeSpawnTest));
    }

    private static int executeSpawnTest(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel serverLevel = source.getLevel();
        if (!(serverLevel instanceof ServerLevel)) {
            source.sendFailure((Component)Component.literal((String)"Command must be run in a server world"));
            return 0;
        }
        ServerLevel serverLevel2 = serverLevel;
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        try {
            HilichurlFighterEntity testEntity = new HilichurlFighterEntity((EntityType<? extends HilichurlFighterEntity>)ModEntities.HILICHURL_FIGHTER.get(), (Level)serverLevel2);
            testEntity.setPos(pos.getX(), pos.getY() + 1, pos.getZ());
            boolean added = serverLevel2.addFreshEntity((Entity)testEntity);
            if (added) {
                source.sendSuccess(() -> Component.literal((String)("SUCCESS: Hilichurl Fighter spawned at " + String.valueOf(pos))), true);
                SpawnGroupData naturalSpawnResult = testEntity.finalizeSpawn((ServerLevelAccessor)serverLevel2, serverLevel2.getCurrentDifficultyAt(pos), MobSpawnType.NATURAL, null);
                source.sendSuccess(() -> Component.literal((String)"Natural spawn finalization completed"), true);
            } else {
                source.sendFailure((Component)Component.literal((String)"FAILED: Could not add entity to world"));
            }
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("ERROR: " + e.getMessage())));
            e.printStackTrace();
        }
        return 1;
    }
}

